/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava.ext.auth.oauth2.providers;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.ext.auth.oauth2.OAuth2ClientOptions;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.rx.java.ObservableFuture;
import io.vertx.rx.java.RxHelper;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import io.vertx.rxjava.ext.auth.oauth2.OAuth2Auth;
import io.vertx.rxjava.ext.auth.oauth2.providers.OpenIDConnectAuth;
import rx.Observable;
import rx.Single;

@RxGen(value=io.vertx.ext.auth.oauth2.providers.SalesforceAuth.class)
public class SalesforceAuth
extends OpenIDConnectAuth {
    public static final TypeArg<SalesforceAuth> __TYPE_ARG = new TypeArg(obj -> new SalesforceAuth((io.vertx.ext.auth.oauth2.providers.SalesforceAuth)obj), SalesforceAuth::getDelegate);
    private final io.vertx.ext.auth.oauth2.providers.SalesforceAuth delegate;

    @Override
    public String toString() {
        return this.delegate.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SalesforceAuth that = (SalesforceAuth)o;
        return this.delegate.equals(that.delegate);
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }

    public SalesforceAuth(io.vertx.ext.auth.oauth2.providers.SalesforceAuth delegate) {
        super((io.vertx.ext.auth.oauth2.providers.OpenIDConnectAuth)delegate);
        this.delegate = delegate;
    }

    public io.vertx.ext.auth.oauth2.providers.SalesforceAuth getDelegate() {
        return this.delegate;
    }

    public static OAuth2Auth create(io.vertx.rxjava.core.Vertx vertx, String clientId, String clientSecret) {
        OAuth2Auth ret = OAuth2Auth.newInstance(io.vertx.ext.auth.oauth2.providers.SalesforceAuth.create((Vertx)vertx.getDelegate(), (String)clientId, (String)clientSecret));
        return ret;
    }

    public static OAuth2Auth create(io.vertx.rxjava.core.Vertx vertx, String clientId, String clientSecret, HttpClientOptions httpClientOptions) {
        OAuth2Auth ret = OAuth2Auth.newInstance(io.vertx.ext.auth.oauth2.providers.SalesforceAuth.create((Vertx)vertx.getDelegate(), (String)clientId, (String)clientSecret, (HttpClientOptions)httpClientOptions));
        return ret;
    }

    public static void discover(io.vertx.rxjava.core.Vertx vertx, OAuth2ClientOptions config, final Handler<AsyncResult<OAuth2Auth>> handler) {
        io.vertx.ext.auth.oauth2.providers.SalesforceAuth.discover((Vertx)vertx.getDelegate(), (OAuth2ClientOptions)config, (Handler)new Handler<AsyncResult<io.vertx.ext.auth.oauth2.OAuth2Auth>>(){

            public void handle(AsyncResult<io.vertx.ext.auth.oauth2.OAuth2Auth> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)OAuth2Auth.newInstance((io.vertx.ext.auth.oauth2.OAuth2Auth)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    @Deprecated
    public static Observable<OAuth2Auth> discoverObservable(io.vertx.rxjava.core.Vertx vertx, OAuth2ClientOptions config) {
        ObservableFuture<OAuth2Auth> handler = RxHelper.observableFuture();
        SalesforceAuth.discover(vertx, config, handler.toHandler());
        return handler;
    }

    public static Single<OAuth2Auth> rxDiscover(io.vertx.rxjava.core.Vertx vertx, OAuth2ClientOptions config) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> SalesforceAuth.discover(vertx, config, (Handler<AsyncResult<OAuth2Auth>>)fut)));
    }

    public static SalesforceAuth newInstance(io.vertx.ext.auth.oauth2.providers.SalesforceAuth arg) {
        return arg != null ? new SalesforceAuth(arg) : null;
    }
}

