/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.reactivex.redis.client;

import io.reactivex.Completable;
import io.reactivex.Flowable;
import io.reactivex.Maybe;
import io.reactivex.Observable;
import io.reactivex.Single;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.core.net.SocketAddress;
import io.vertx.reactivex.core.streams.Pipe;
import io.vertx.reactivex.core.streams.ReadStream;
import io.vertx.reactivex.core.streams.WriteStream;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.redis.client.Request;
import io.vertx.reactivex.redis.client.Response;
import io.vertx.redis.client.RedisOptions;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;

@RxGen(value=io.vertx.redis.client.Redis.class)
public class Redis
implements ReadStream<Response> {
    public static final TypeArg<Redis> __TYPE_ARG = new TypeArg(obj -> new Redis((io.vertx.redis.client.Redis)obj), Redis::getDelegate);
    private final io.vertx.redis.client.Redis delegate;
    private Observable<Response> observable;
    private Flowable<Response> flowable;

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Redis that = (Redis)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public Redis(io.vertx.redis.client.Redis delegate) {
        this.delegate = delegate;
    }

    public io.vertx.redis.client.Redis getDelegate() {
        return this.delegate;
    }

    @Override
    public synchronized Observable<Response> toObservable() {
        if (this.observable == null) {
            Function<io.vertx.redis.client.Response, Response> conv = Response::newInstance;
            this.observable = ObservableHelper.toObservable(this.delegate, conv);
        }
        return this.observable;
    }

    @Override
    public synchronized Flowable<Response> toFlowable() {
        if (this.flowable == null) {
            Function<io.vertx.redis.client.Response, Response> conv = Response::newInstance;
            this.flowable = FlowableHelper.toFlowable(this.delegate, conv);
        }
        return this.flowable;
    }

    @Override
    public Pipe<Response> pipe() {
        Pipe<Response> ret = Pipe.newInstance(this.delegate.pipe(), Response.__TYPE_ARG);
        return ret;
    }

    @Override
    public void pipeTo(WriteStream<Response> dst) {
        this.delegate.pipeTo(dst.getDelegate());
    }

    @Override
    public void pipeTo(WriteStream<Response> dst, Handler<AsyncResult<Void>> handler) {
        this.delegate.pipeTo(dst.getDelegate(), handler);
    }

    public Completable rxPipeTo(WriteStream<Response> dst) {
        return AsyncResultCompletable.toCompletable(handler -> this.pipeTo(dst, (Handler<AsyncResult<Void>>)handler));
    }

    public static Redis createClient(io.vertx.reactivex.core.Vertx vertx, SocketAddress address) {
        Redis ret = Redis.newInstance(io.vertx.redis.client.Redis.createClient((Vertx)vertx.getDelegate(), (io.vertx.core.net.SocketAddress)address.getDelegate()));
        return ret;
    }

    public static Redis createClient(io.vertx.reactivex.core.Vertx vertx, RedisOptions options) {
        Redis ret = Redis.newInstance(io.vertx.redis.client.Redis.createClient((Vertx)vertx.getDelegate(), (RedisOptions)options));
        return ret;
    }

    public Redis connect(final Handler<AsyncResult<Redis>> handler) {
        this.delegate.connect((Handler)new Handler<AsyncResult<io.vertx.redis.client.Redis>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Redis> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Redis.newInstance((io.vertx.redis.client.Redis)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    public Single<Redis> rxConnect() {
        return AsyncResultSingle.toSingle(handler -> this.connect((Handler<AsyncResult<Redis>>)handler));
    }

    @Override
    public Redis exceptionHandler(Handler<Throwable> handler) {
        this.delegate.exceptionHandler(handler);
        return this;
    }

    public Redis handler(final Handler<Response> handler) {
        this.delegate.handler((Handler)new Handler<io.vertx.redis.client.Response>(){

            public void handle(io.vertx.redis.client.Response event) {
                handler.handle((Object)Response.newInstance(event));
            }
        });
        return this;
    }

    public Redis pause() {
        this.delegate.pause();
        return this;
    }

    public Redis resume() {
        this.delegate.resume();
        return this;
    }

    public Redis fetch(long amount) {
        this.delegate.fetch(amount);
        return this;
    }

    public Redis endHandler(Handler<Void> endHandler) {
        this.delegate.endHandler(endHandler);
        return this;
    }

    public Redis send(Request command, final Handler<AsyncResult<Response>> onSend) {
        this.delegate.send(command.getDelegate(), (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    onSend.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    onSend.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    public Maybe<Response> rxSend(Request command) {
        return AsyncResultMaybe.toMaybe(handler -> this.send(command, (Handler<AsyncResult<Response>>)handler));
    }

    public Redis batch(List<Request> commands, final Handler<AsyncResult<List<Response>>> handler) {
        this.delegate.batch(commands.stream().map(elt -> elt.getDelegate()).collect(Collectors.toList()), (Handler)new Handler<AsyncResult<List<io.vertx.redis.client.Response>>>(){

            public void handle(AsyncResult<List<io.vertx.redis.client.Response>> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture(((List)ar.result()).stream().map(elt -> Response.newInstance(elt)).collect(Collectors.toList())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    public Single<List<Response>> rxBatch(List<Request> commands) {
        return AsyncResultSingle.toSingle(handler -> this.batch(commands, (Handler<AsyncResult<List<Response>>>)handler));
    }

    public SocketAddress socketAddress() {
        SocketAddress ret = SocketAddress.newInstance(this.delegate.socketAddress());
        return ret;
    }

    public void close() {
        this.delegate.close();
    }

    public static Redis newInstance(io.vertx.redis.client.Redis arg) {
        return arg != null ? new Redis(arg) : null;
    }
}

