/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava.servicediscovery;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.rx.java.ObservableFuture;
import io.vertx.rx.java.RxHelper;
import io.vertx.rxjava.servicediscovery.ServiceReference;
import io.vertx.rxjava.servicediscovery.spi.ServiceExporter;
import io.vertx.rxjava.servicediscovery.spi.ServiceImporter;
import io.vertx.servicediscovery.Record;
import io.vertx.servicediscovery.ServiceDiscoveryOptions;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import rx.Observable;

public class ServiceDiscovery {
    final io.vertx.servicediscovery.ServiceDiscovery delegate;

    public ServiceDiscovery(io.vertx.servicediscovery.ServiceDiscovery delegate) {
        this.delegate = delegate;
    }

    public Object getDelegate() {
        return this.delegate;
    }

    public static ServiceDiscovery create(io.vertx.rxjava.core.Vertx vertx, ServiceDiscoveryOptions options) {
        ServiceDiscovery ret = ServiceDiscovery.newInstance(io.vertx.servicediscovery.ServiceDiscovery.create((Vertx)vertx.getDelegate(), options));
        return ret;
    }

    public static ServiceDiscovery create(io.vertx.rxjava.core.Vertx vertx) {
        ServiceDiscovery ret = ServiceDiscovery.newInstance(io.vertx.servicediscovery.ServiceDiscovery.create((Vertx)vertx.getDelegate()));
        return ret;
    }

    public ServiceReference getReference(Record record) {
        ServiceReference ret = ServiceReference.newInstance(this.delegate.getReference(record));
        return ret;
    }

    public ServiceReference getReferenceWithConfiguration(Record record, JsonObject configuration) {
        ServiceReference ret = ServiceReference.newInstance(this.delegate.getReferenceWithConfiguration(record, configuration));
        return ret;
    }

    public boolean release(ServiceReference reference) {
        boolean ret = this.delegate.release((io.vertx.servicediscovery.ServiceReference)reference.getDelegate());
        return ret;
    }

    public ServiceDiscovery registerServiceImporter(ServiceImporter importer, JsonObject configuration) {
        ServiceDiscovery ret = ServiceDiscovery.newInstance(this.delegate.registerServiceImporter((io.vertx.servicediscovery.spi.ServiceImporter)importer.getDelegate(), configuration));
        return ret;
    }

    public ServiceDiscovery registerServiceExporter(ServiceExporter exporter, JsonObject configuration) {
        ServiceDiscovery ret = ServiceDiscovery.newInstance(this.delegate.registerServiceExporter((io.vertx.servicediscovery.spi.ServiceExporter)exporter.getDelegate(), configuration));
        return ret;
    }

    public void close() {
        this.delegate.close();
    }

    public void publish(Record record, Handler<AsyncResult<Record>> resultHandler) {
        this.delegate.publish(record, resultHandler);
    }

    public Observable<Record> publishObservable(Record record) {
        ObservableFuture resultHandler = RxHelper.observableFuture();
        this.publish(record, (Handler<AsyncResult<Record>>)resultHandler.toHandler());
        return resultHandler;
    }

    public void unpublish(String id, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.unpublish(id, resultHandler);
    }

    public Observable<Void> unpublishObservable(String id) {
        ObservableFuture resultHandler = RxHelper.observableFuture();
        this.unpublish(id, (Handler<AsyncResult<Void>>)resultHandler.toHandler());
        return resultHandler;
    }

    public void getRecord(JsonObject filter, Handler<AsyncResult<Record>> resultHandler) {
        this.delegate.getRecord(filter, resultHandler);
    }

    public Observable<Record> getRecordObservable(JsonObject filter) {
        ObservableFuture resultHandler = RxHelper.observableFuture();
        this.getRecord(filter, (Handler<AsyncResult<Record>>)resultHandler.toHandler());
        return resultHandler;
    }

    public void getRecord(final Function<Record, Boolean> filter, Handler<AsyncResult<Record>> resultHandler) {
        this.delegate.getRecord(new Function<Record, Boolean>(){

            @Override
            public Boolean apply(Record arg) {
                Boolean ret = (Boolean)filter.apply(arg);
                return ret;
            }
        }, resultHandler);
    }

    public Observable<Record> getRecordObservable(Function<Record, Boolean> filter) {
        ObservableFuture resultHandler = RxHelper.observableFuture();
        this.getRecord(filter, (Handler<AsyncResult<Record>>)resultHandler.toHandler());
        return resultHandler;
    }

    public void getRecord(final Function<Record, Boolean> filter, boolean includeOutOfService, Handler<AsyncResult<Record>> resultHandler) {
        this.delegate.getRecord(new Function<Record, Boolean>(){

            @Override
            public Boolean apply(Record arg) {
                Boolean ret = (Boolean)filter.apply(arg);
                return ret;
            }
        }, includeOutOfService, resultHandler);
    }

    public Observable<Record> getRecordObservable(Function<Record, Boolean> filter, boolean includeOutOfService) {
        ObservableFuture resultHandler = RxHelper.observableFuture();
        this.getRecord(filter, includeOutOfService, (Handler<AsyncResult<Record>>)resultHandler.toHandler());
        return resultHandler;
    }

    public void getRecords(JsonObject filter, Handler<AsyncResult<List<Record>>> resultHandler) {
        this.delegate.getRecords(filter, resultHandler);
    }

    public Observable<List<Record>> getRecordsObservable(JsonObject filter) {
        ObservableFuture resultHandler = RxHelper.observableFuture();
        this.getRecords(filter, (Handler<AsyncResult<List<Record>>>)resultHandler.toHandler());
        return resultHandler;
    }

    public void getRecords(final Function<Record, Boolean> filter, Handler<AsyncResult<List<Record>>> resultHandler) {
        this.delegate.getRecords(new Function<Record, Boolean>(){

            @Override
            public Boolean apply(Record arg) {
                Boolean ret = (Boolean)filter.apply(arg);
                return ret;
            }
        }, resultHandler);
    }

    public Observable<List<Record>> getRecordsObservable(Function<Record, Boolean> filter) {
        ObservableFuture resultHandler = RxHelper.observableFuture();
        this.getRecords(filter, (Handler<AsyncResult<List<Record>>>)resultHandler.toHandler());
        return resultHandler;
    }

    public void getRecords(final Function<Record, Boolean> filter, boolean includeOutOfService, Handler<AsyncResult<List<Record>>> resultHandler) {
        this.delegate.getRecords(new Function<Record, Boolean>(){

            @Override
            public Boolean apply(Record arg) {
                Boolean ret = (Boolean)filter.apply(arg);
                return ret;
            }
        }, includeOutOfService, resultHandler);
    }

    public Observable<List<Record>> getRecordsObservable(Function<Record, Boolean> filter, boolean includeOutOfService) {
        ObservableFuture resultHandler = RxHelper.observableFuture();
        this.getRecords(filter, includeOutOfService, (Handler<AsyncResult<List<Record>>>)resultHandler.toHandler());
        return resultHandler;
    }

    public void update(Record record, Handler<AsyncResult<Record>> resultHandler) {
        this.delegate.update(record, resultHandler);
    }

    public Observable<Record> updateObservable(Record record) {
        ObservableFuture resultHandler = RxHelper.observableFuture();
        this.update(record, (Handler<AsyncResult<Record>>)resultHandler.toHandler());
        return resultHandler;
    }

    public Set<ServiceReference> bindings() {
        Set<ServiceReference> ret = this.delegate.bindings().stream().map(elt -> ServiceReference.newInstance(elt)).collect(Collectors.toSet());
        return ret;
    }

    public static void releaseServiceObject(ServiceDiscovery discovery, Object svcObject) {
        io.vertx.servicediscovery.ServiceDiscovery.releaseServiceObject((io.vertx.servicediscovery.ServiceDiscovery)discovery.getDelegate(), svcObject);
    }

    public static ServiceDiscovery newInstance(io.vertx.servicediscovery.ServiceDiscovery arg) {
        return arg != null ? new ServiceDiscovery(arg) : null;
    }
}

