/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.servicediscovery;

import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.servicediscovery.Record;
import io.vertx.servicediscovery.ServiceDiscoveryOptions;
import io.vertx.servicediscovery.ServiceReference;
import io.vertx.servicediscovery.impl.DiscoveryImpl;
import io.vertx.servicediscovery.spi.ServiceExporter;
import io.vertx.servicediscovery.spi.ServiceImporter;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;

@VertxGen
public interface ServiceDiscovery {
    public static ServiceDiscovery create(Vertx vertx, ServiceDiscoveryOptions options) {
        return new DiscoveryImpl(vertx, options);
    }

    public static ServiceDiscovery create(Vertx vertx) {
        return ServiceDiscovery.create(vertx, new ServiceDiscoveryOptions());
    }

    public ServiceReference getReference(Record var1);

    public ServiceReference getReferenceWithConfiguration(Record var1, JsonObject var2);

    public boolean release(ServiceReference var1);

    public ServiceDiscovery registerServiceImporter(ServiceImporter var1, JsonObject var2);

    public ServiceDiscovery registerServiceImporter(ServiceImporter var1, JsonObject var2, Handler<AsyncResult<Void>> var3);

    public ServiceDiscovery registerServiceExporter(ServiceExporter var1, JsonObject var2);

    public ServiceDiscovery registerServiceExporter(ServiceExporter var1, JsonObject var2, Handler<AsyncResult<Void>> var3);

    public void close();

    public void publish(Record var1, Handler<AsyncResult<Record>> var2);

    public void unpublish(String var1, Handler<AsyncResult<Void>> var2);

    public void getRecord(JsonObject var1, Handler<AsyncResult<Record>> var2);

    public void getRecord(Function<Record, Boolean> var1, Handler<AsyncResult<Record>> var2);

    public void getRecord(Function<Record, Boolean> var1, boolean var2, Handler<AsyncResult<Record>> var3);

    public void getRecords(JsonObject var1, Handler<AsyncResult<List<Record>>> var2);

    public void getRecords(Function<Record, Boolean> var1, Handler<AsyncResult<List<Record>>> var2);

    public void getRecords(Function<Record, Boolean> var1, boolean var2, Handler<AsyncResult<List<Record>>> var3);

    public void update(Record var1, Handler<AsyncResult<Record>> var2);

    public Set<ServiceReference> bindings();

    public ServiceDiscoveryOptions options();

    public static void releaseServiceObject(ServiceDiscovery discovery, Object svcObject) {
        Objects.requireNonNull(discovery);
        Objects.requireNonNull(svcObject);
        Set<ServiceReference> references = discovery.bindings();
        references.stream().filter(ref -> svcObject.equals(ref.cached())).forEach(discovery::release);
    }
}

