/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.servicediscovery.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.spi.cluster.ClusterManager;
import io.vertx.servicediscovery.impl.LocalMapWrapper;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AsyncMap<K, V> {
    private final Vertx vertx;
    private final Map<K, V> syncMap;

    public AsyncMap(Vertx vertx, String name) {
        this.vertx = vertx;
        ClusterManager clusterManager = ((VertxInternal)vertx).getClusterManager();
        this.syncMap = clusterManager == null ? new LocalMapWrapper(vertx.sharedData().getLocalMap(name)) : clusterManager.getSyncMap(name);
    }

    public void getAll(Handler<AsyncResult<Map<K, V>>> asyncResultHandler) {
        this.vertx.executeBlocking(future -> {
            LinkedHashMap map = new LinkedHashMap();
            this.syncMap.entrySet().stream().forEach(entry -> map.put(entry.getKey(), entry.getValue()));
            future.complete(map);
        }, asyncResultHandler);
    }

    public void keySet(Handler<AsyncResult<Set<K>>> asyncResultHandler) {
        this.vertx.executeBlocking(future -> future.complete(this.syncMap.keySet()), asyncResultHandler);
    }

    public void values(Handler<AsyncResult<List<V>>> asyncResultHandler) {
        this.vertx.executeBlocking(future -> future.complete(new ArrayList<V>(this.syncMap.values())), asyncResultHandler);
    }

    public void get(K k, Handler<AsyncResult<V>> handler) {
        this.vertx.executeBlocking(future -> future.complete(this.syncMap.get(k)), handler);
    }

    public void put(K k, V v, Handler<AsyncResult<Void>> handler) {
        this.vertx.executeBlocking(future -> {
            this.syncMap.put(k, v);
            future.complete();
        }, handler);
    }

    public void remove(K k, Handler<AsyncResult<V>> handler) {
        this.vertx.executeBlocking(future -> future.complete(this.syncMap.remove(k)), handler);
    }

    public void size(Handler<AsyncResult<Integer>> handler) {
        this.vertx.executeBlocking(future -> future.complete((Object)this.syncMap.size()), handler);
    }
}

