/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.servicediscovery.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.CompositeFuture;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.json.JsonObject;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.servicediscovery.Record;
import io.vertx.servicediscovery.ServiceDiscovery;
import io.vertx.servicediscovery.ServiceDiscoveryOptions;
import io.vertx.servicediscovery.ServiceReference;
import io.vertx.servicediscovery.Status;
import io.vertx.servicediscovery.impl.DefaultServiceDiscoveryBackend;
import io.vertx.servicediscovery.impl.ServiceTypes;
import io.vertx.servicediscovery.spi.ServiceDiscoveryBackend;
import io.vertx.servicediscovery.spi.ServiceExporter;
import io.vertx.servicediscovery.spi.ServiceImporter;
import io.vertx.servicediscovery.spi.ServicePublisher;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.function.Function;
import java.util.stream.Collectors;

public class DiscoveryImpl
implements ServiceDiscovery,
ServicePublisher {
    private final Vertx vertx;
    private final String announce;
    private final String usage;
    private final ServiceDiscoveryBackend backend;
    private final Set<ServiceImporter> importers = new CopyOnWriteArraySet<ServiceImporter>();
    private final Set<ServiceExporter> exporters = new CopyOnWriteArraySet<ServiceExporter>();
    private final Set<ServiceReference> bindings = new CopyOnWriteArraySet<ServiceReference>();
    private static final Logger LOGGER = LoggerFactory.getLogger((String)DiscoveryImpl.class.getName());
    private final String id;
    private final ServiceDiscoveryOptions options;

    public DiscoveryImpl(Vertx vertx, ServiceDiscoveryOptions options) {
        this.vertx = vertx;
        this.announce = options.getAnnounceAddress();
        this.usage = options.getUsageAddress();
        this.backend = this.getBackend(options.getBackendConfiguration().getString("backend-name", null));
        this.backend.init(vertx, options.getBackendConfiguration());
        this.id = options.getName() != null ? options.getName() : this.getNodeId(vertx);
        this.options = options;
    }

    private String getNodeId(Vertx vertx) {
        if (vertx.isClustered()) {
            return ((VertxInternal)vertx).getNodeID();
        }
        return "localhost";
    }

    private ServiceDiscoveryBackend getBackend(String maybeName) {
        ServiceLoader<ServiceDiscoveryBackend> backends = ServiceLoader.load(ServiceDiscoveryBackend.class);
        Iterator<ServiceDiscoveryBackend> iterator = backends.iterator();
        if (maybeName == null) {
            if (!iterator.hasNext()) {
                return new DefaultServiceDiscoveryBackend();
            }
            return iterator.next();
        }
        if (maybeName.equals(DefaultServiceDiscoveryBackend.class.getName())) {
            return new DefaultServiceDiscoveryBackend();
        }
        while (iterator.hasNext()) {
            ServiceDiscoveryBackend backend = iterator.next();
            if (!backend.name().equals(maybeName)) continue;
            return backend;
        }
        throw new IllegalStateException("Cannot find the discovery backend implementation with name " + maybeName + " in the classpath");
    }

    @Override
    public ServiceReference getReference(Record record) {
        return this.getReferenceWithConfiguration(record, new JsonObject());
    }

    @Override
    public ServiceReference getReferenceWithConfiguration(Record record, JsonObject configuration) {
        ServiceReference reference = ServiceTypes.get(record).get(this.vertx, this, record, configuration);
        this.bindings.add(reference);
        this.sendBindEvent(reference);
        return reference;
    }

    private void sendBindEvent(ServiceReference reference) {
        if (this.usage == null) {
            return;
        }
        this.vertx.eventBus().publish(this.usage, (Object)new JsonObject().put("type", "bind").put("record", reference.record().toJson()).put("id", this.id));
    }

    @Override
    public boolean release(ServiceReference reference) {
        boolean removed = this.bindings.remove(reference);
        reference.release();
        this.sendUnbindEvent(reference);
        return removed;
    }

    private void sendUnbindEvent(ServiceReference reference) {
        if (this.usage == null) {
            return;
        }
        this.vertx.eventBus().publish(this.usage, (Object)new JsonObject().put("type", "release").put("record", reference.record().toJson()).put("id", this.id));
    }

    @Override
    public ServiceDiscovery registerServiceImporter(ServiceImporter importer, JsonObject configuration, Handler<AsyncResult<Void>> completionHandler) {
        JsonObject conf = configuration == null ? new JsonObject() : configuration;
        Future completed = Future.future();
        completed.setHandler(ar -> {
            if (ar.failed()) {
                LOGGER.error((Object)("Cannot start the service importer " + importer), ar.cause());
                if (completionHandler != null) {
                    completionHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            } else {
                this.importers.add(importer);
                LOGGER.info((Object)("Service importer " + importer + " started"));
                if (completionHandler != null) {
                    completionHandler.handle((Object)Future.succeededFuture(null));
                }
            }
        });
        importer.start(this.vertx, this, conf, (Future<Void>)completed);
        return this;
    }

    @Override
    public ServiceDiscovery registerServiceImporter(ServiceImporter importer, JsonObject configuration) {
        return this.registerServiceImporter(importer, configuration, null);
    }

    @Override
    public ServiceDiscovery registerServiceExporter(ServiceExporter exporter, JsonObject configuration) {
        return this.registerServiceExporter(exporter, configuration, null);
    }

    @Override
    public ServiceDiscovery registerServiceExporter(ServiceExporter exporter, JsonObject configuration, Handler<AsyncResult<Void>> completionHandler) {
        JsonObject conf = configuration == null ? new JsonObject() : configuration;
        Future completed = Future.future();
        completed.setHandler(ar -> {
            if (ar.failed()) {
                LOGGER.error((Object)("Cannot start the service importer " + exporter), ar.cause());
                if (completionHandler != null) {
                    completionHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            } else {
                this.exporters.add(exporter);
                LOGGER.info((Object)("Service exporter " + exporter + " started"));
                if (completionHandler != null) {
                    completionHandler.handle((Object)Future.succeededFuture(null));
                }
            }
        });
        exporter.init(this.vertx, this, conf, (Future<Void>)completed);
        return this;
    }

    @Override
    public void close() {
        Future future;
        LOGGER.info((Object)"Stopping service discovery");
        ArrayList<Future> futures = new ArrayList<Future>();
        for (ServiceImporter importer : this.importers) {
            future = Future.future();
            importer.stop(this.vertx, this, (Future<Void>)future);
            futures.add(future);
        }
        for (ServiceExporter exporter : this.exporters) {
            future = Future.future();
            exporter.close((Handler<Void>)((Handler)arg_0 -> ((Future)future).complete(arg_0)));
            futures.add(future);
        }
        this.bindings.forEach(ServiceReference::release);
        this.bindings.clear();
        CompositeFuture.all(futures).setHandler(ar -> {
            if (ar.succeeded()) {
                LOGGER.info((Object)"Discovery bridges stopped");
            } else {
                LOGGER.warn((Object)"Some discovery bridges did not stopped smoothly", ar.cause());
            }
        });
    }

    @Override
    public void publish(Record record, Handler<AsyncResult<Record>> resultHandler) {
        Status status = record.getStatus() != null && record.getStatus() != Status.UNKNOWN && record.getStatus() != Status.DOWN ? record.getStatus() : Status.UP;
        this.backend.store(record.setStatus(status), resultHandler);
        for (ServiceExporter exporter : this.exporters) {
            exporter.onPublish(new Record(record));
        }
        Record announcedRecord = new Record(record);
        announcedRecord.setRegistration(null).setStatus(status);
        this.vertx.eventBus().publish(this.announce, (Object)announcedRecord.toJson());
    }

    @Override
    public void unpublish(String id, Handler<AsyncResult<Void>> resultHandler) {
        this.backend.remove(id, (Handler<AsyncResult<Record>>)((Handler)record -> {
            if (record.failed()) {
                resultHandler.handle((Object)Future.failedFuture((Throwable)record.cause()));
                return;
            }
            for (ServiceExporter exporter : this.exporters) {
                exporter.onUnpublish(id);
            }
            Record announcedRecord = new Record((Record)record.result());
            announcedRecord.setRegistration(null).setStatus(Status.DOWN);
            this.vertx.eventBus().publish(this.announce, (Object)announcedRecord.toJson());
            resultHandler.handle((Object)Future.succeededFuture());
        }));
    }

    @Override
    public void getRecord(JsonObject filter, Handler<AsyncResult<Record>> resultHandler) {
        Function<Record, Boolean> accept;
        boolean includeOutOfService = false;
        if (filter == null) {
            accept = r -> true;
        } else {
            includeOutOfService = filter.getString("status") != null;
            accept = r -> r.match(filter);
        }
        this.getRecord(accept, includeOutOfService, resultHandler);
    }

    @Override
    public void getRecord(Function<Record, Boolean> filter, Handler<AsyncResult<Record>> resultHandler) {
        this.getRecord(filter, false, resultHandler);
    }

    @Override
    public void getRecord(Function<Record, Boolean> filter, boolean includeOutOfService, Handler<AsyncResult<Record>> resultHandler) {
        Objects.requireNonNull(filter);
        this.backend.getRecords((Handler<AsyncResult<List<Record>>>)((Handler)list -> {
            if (list.failed()) {
                resultHandler.handle((Object)Future.failedFuture((Throwable)list.cause()));
            } else {
                Optional<Record> any = ((List)list.result()).stream().filter(filter::apply).filter(record -> includeOutOfService || record.getStatus() == Status.UP).findAny();
                if (any.isPresent()) {
                    resultHandler.handle((Object)Future.succeededFuture((Object)any.get()));
                } else {
                    resultHandler.handle((Object)Future.succeededFuture(null));
                }
            }
        }));
    }

    @Override
    public void getRecords(JsonObject filter, Handler<AsyncResult<List<Record>>> resultHandler) {
        Function<Record, Boolean> accept;
        boolean includeOutOfService = false;
        if (filter == null) {
            accept = r -> true;
        } else {
            includeOutOfService = filter.getString("status") != null;
            accept = r -> r.match(filter);
        }
        this.getRecords(accept, includeOutOfService, resultHandler);
    }

    @Override
    public void getRecords(Function<Record, Boolean> filter, Handler<AsyncResult<List<Record>>> resultHandler) {
        this.getRecords(filter, false, resultHandler);
    }

    @Override
    public void getRecords(Function<Record, Boolean> filter, boolean includeOutOfService, Handler<AsyncResult<List<Record>>> resultHandler) {
        Objects.requireNonNull(filter);
        this.backend.getRecords((Handler<AsyncResult<List<Record>>>)((Handler)list -> {
            if (list.failed()) {
                resultHandler.handle((Object)Future.failedFuture((Throwable)list.cause()));
            } else {
                resultHandler.handle((Object)Future.succeededFuture(((List)list.result()).stream().filter(filter::apply).filter(record -> includeOutOfService || record.getStatus() == Status.UP).collect(Collectors.toList())));
            }
        }));
    }

    @Override
    public void update(Record record, Handler<AsyncResult<Record>> resultHandler) {
        this.backend.update(record, (Handler<AsyncResult<Void>>)((Handler)ar -> {
            if (ar.failed()) {
                resultHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
            } else {
                resultHandler.handle((Object)Future.succeededFuture((Object)record));
            }
        }));
        for (ServiceExporter exporter : this.exporters) {
            exporter.onUpdate(record);
        }
        Record announcedRecord = new Record(record);
        this.vertx.eventBus().publish(this.announce, (Object)announcedRecord.toJson());
    }

    @Override
    public Set<ServiceReference> bindings() {
        return new HashSet<ServiceReference>(this.bindings);
    }

    @Override
    public ServiceDiscoveryOptions options() {
        return this.options;
    }

    public void unbind(ServiceReference reference) {
        if (this.bindings.remove(reference)) {
            this.sendUnbindEvent(reference);
        }
    }
}

