/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.serviceproxy;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.eventbus.ReplyException;
import io.vertx.core.eventbus.ReplyFailure;
import io.vertx.core.json.JsonObject;

public class ServiceException
extends ReplyException {
    private final JsonObject debugInfo;

    public ServiceException(int failureCode, String message) {
        this(failureCode, message, new JsonObject());
    }

    public ServiceException(int failureCode, String message, JsonObject debugInfo) {
        super(ReplyFailure.RECIPIENT_FAILURE, failureCode, message);
        this.debugInfo = debugInfo;
    }

    public JsonObject getDebugInfo() {
        return this.debugInfo;
    }

    public static <T> AsyncResult<T> fail(int failureCode, String message) {
        return Future.failedFuture((Throwable)((Object)new ServiceException(failureCode, message)));
    }

    public static <T> AsyncResult<T> fail(int failureCode, String message, JsonObject debugInfo) {
        return Future.failedFuture((Throwable)((Object)new ServiceException(failureCode, message, debugInfo)));
    }
}

