/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.serviceproxy;

import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.eventbus.EventBus;
import io.vertx.core.eventbus.Message;
import io.vertx.core.eventbus.MessageConsumer;
import io.vertx.core.eventbus.ReplyException;
import io.vertx.core.json.JsonObject;
import io.vertx.serviceproxy.impl.InterceptorHolder;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;

public abstract class ProxyHandler
implements Handler<Message<JsonObject>> {
    protected boolean closed;
    protected MessageConsumer<JsonObject> consumer;

    public void close() {
        this.consumer.unregister();
        this.closed = true;
    }

    public MessageConsumer<JsonObject> register(EventBus eventBus, String address) {
        this.consumer = eventBus.consumer(address, (Handler)this);
        return this.consumer;
    }

    public MessageConsumer<JsonObject> register(Vertx vertx, String address, List<InterceptorHolder> interceptorHolders) {
        Objects.requireNonNull(interceptorHolders);
        Handler<Message<JsonObject>> handler = this.configureHandler(vertx, interceptorHolders);
        this.consumer = vertx.eventBus().consumer(address, handler);
        return this.consumer;
    }

    public MessageConsumer<JsonObject> registerLocal(EventBus eventBus, String address) {
        this.consumer = eventBus.localConsumer(address, (Handler)this);
        return this.consumer;
    }

    public MessageConsumer<JsonObject> registerLocal(Vertx vertx, String address, List<InterceptorHolder> interceptorHolders) {
        Objects.requireNonNull(interceptorHolders);
        Handler<Message<JsonObject>> handler = this.configureHandler(vertx, interceptorHolders);
        this.consumer = vertx.eventBus().localConsumer(address, handler);
        return this.consumer;
    }

    private Handler<Message<JsonObject>> configureHandler(Vertx vertx, List<InterceptorHolder> interceptorHolders) {
        ProxyHandler handler = this;
        HashMap context = new HashMap();
        for (int i = interceptorHolders.size() - 1; i >= 0; --i) {
            InterceptorHolder interceptorHolder = interceptorHolders.get(i);
            ProxyHandler prev = handler;
            handler = msg -> {
                String action = msg.headers().get("action");
                String holderAction = interceptorHolder.action();
                if (holderAction == null || action.equals(holderAction)) {
                    interceptorHolder.interceptor().intercept(vertx, context, (Message<JsonObject>)msg).onSuccess(prev).onFailure(err -> {
                        ReplyException exception = (ReplyException)err;
                        msg.fail(exception.failureCode(), exception.getMessage());
                    });
                } else {
                    prev.handle(msg);
                }
            };
        }
        return handler;
    }
}

