/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.serviceproxy;

import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.eventbus.Message;
import io.vertx.core.eventbus.MessageConsumer;
import io.vertx.core.json.JsonObject;
import io.vertx.serviceproxy.ProxyHandler;
import io.vertx.serviceproxy.ServiceInterceptor;
import io.vertx.serviceproxy.impl.InterceptorHolder;
import io.vertx.serviceproxy.impl.utils.InterceptorUtils;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

public class ServiceBinder {
    public static final long DEFAULT_CONNECTION_TIMEOUT = 300L;
    private final Vertx vertx;
    private String address;
    private boolean topLevel = true;
    private long timeoutSeconds = 300L;
    private List<InterceptorHolder> interceptorHolders;
    private boolean includeDebugInfo = false;

    public ServiceBinder(Vertx vertx) {
        Objects.requireNonNull(vertx);
        this.vertx = vertx;
    }

    public ServiceBinder setAddress(String address) {
        this.address = address;
        return this;
    }

    public ServiceBinder setTopLevel(boolean topLevel) {
        this.topLevel = topLevel;
        return this;
    }

    public ServiceBinder setTimeoutSeconds(long timeoutSeconds) {
        this.timeoutSeconds = timeoutSeconds;
        return this;
    }

    public ServiceBinder setIncludeDebugInfo(boolean includeDebugInfo) {
        this.includeDebugInfo = includeDebugInfo;
        return this;
    }

    public ServiceBinder addInterceptor(String action, ServiceInterceptor interceptor) {
        this.checkAndAddInterceptor(action, interceptor);
        return this;
    }

    @Deprecated
    public ServiceBinder addInterceptor(Function<Message<JsonObject>, Future<Message<JsonObject>>> interceptor) {
        ServiceInterceptor serviceInterceptor = (vertx, context, msg) -> (Future)interceptor.apply(msg);
        this.checkAndAddInterceptor(serviceInterceptor);
        return this;
    }

    @Deprecated
    public ServiceBinder addInterceptor(String action, Function<Message<JsonObject>, Future<Message<JsonObject>>> interceptor) {
        ServiceInterceptor serviceInterceptor = (vertx, context, msg) -> (Future)interceptor.apply(msg);
        this.checkAndAddInterceptor(action, serviceInterceptor);
        return this;
    }

    public ServiceBinder addInterceptor(ServiceInterceptor interceptor) {
        this.checkAndAddInterceptor(interceptor);
        return this;
    }

    public <T> MessageConsumer<JsonObject> register(Class<T> clazz, T service) {
        Objects.requireNonNull(this.address);
        return this.getProxyHandler(clazz, service).register(this.vertx, this.address, this.getInterceptorHolders());
    }

    public <T> MessageConsumer<JsonObject> registerLocal(Class<T> clazz, T service) {
        Objects.requireNonNull(this.address);
        return this.getProxyHandler(clazz, service).registerLocal(this.vertx, this.address, this.getInterceptorHolders());
    }

    public void unregister(MessageConsumer<JsonObject> consumer) {
        Objects.requireNonNull(consumer);
        if (consumer instanceof ProxyHandler) {
            ((ProxyHandler)consumer).close();
        } else {
            consumer.unregister();
        }
    }

    private void checkAndAddInterceptor(String action, ServiceInterceptor interceptor) {
        List<InterceptorHolder> currentInterceptorHolders = this.getInterceptorHolders();
        InterceptorUtils.checkInterceptorOrder(currentInterceptorHolders, interceptor);
        currentInterceptorHolders.add(new InterceptorHolder(action, interceptor));
    }

    private void checkAndAddInterceptor(ServiceInterceptor interceptor) {
        List<InterceptorHolder> currentInterceptorHolders = this.getInterceptorHolders();
        InterceptorUtils.checkInterceptorOrder(currentInterceptorHolders, interceptor);
        currentInterceptorHolders.add(new InterceptorHolder(interceptor));
    }

    private <T> ProxyHandler getProxyHandler(Class<T> clazz, T service) {
        String handlerClassName = clazz.getName() + "VertxProxyHandler";
        Class<?> handlerClass = ServiceBinder.loadClass(handlerClassName, clazz);
        Constructor<?> constructor = ServiceBinder.getConstructor(handlerClass, Vertx.class, clazz, Boolean.TYPE, Long.TYPE, Boolean.TYPE);
        Object instance = ServiceBinder.createInstance(constructor, this.vertx, service, this.topLevel, this.timeoutSeconds, this.includeDebugInfo);
        return (ProxyHandler)instance;
    }

    private static Class<?> loadClass(String name, Class<?> origin) {
        try {
            return origin.getClassLoader().loadClass(name);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Cannot find proxyClass: " + name, e);
        }
    }

    private static Constructor<?> getConstructor(Class<?> clazz, Class<?> ... types) {
        try {
            return clazz.getDeclaredConstructor(types);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("Cannot find constructor on: " + clazz.getName(), e);
        }
    }

    private static Object createInstance(Constructor<?> constructor, Object ... args) {
        try {
            return constructor.newInstance(args);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to call constructor on", e);
        }
    }

    private List<InterceptorHolder> getInterceptorHolders() {
        if (this.interceptorHolders == null) {
            this.interceptorHolders = new ArrayList<InterceptorHolder>();
        }
        return this.interceptorHolders;
    }
}

