/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web;

import io.vertx.codegen.annotations.Fluent;
import io.vertx.codegen.annotations.Nullable;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpMethod;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.impl.HttpStatusException;
import java.util.List;
import java.util.Set;
import java.util.function.Function;

@VertxGen
public interface Route {
    @Fluent
    public Route method(HttpMethod var1);

    @Fluent
    public Route path(String var1);

    @Fluent
    public Route pathRegex(String var1);

    @Fluent
    public Route produces(String var1);

    @Fluent
    public Route consumes(String var1);

    @Fluent
    public Route virtualHost(String var1);

    @Fluent
    public Route order(int var1);

    @Fluent
    public Route last();

    @Fluent
    public Route handler(Handler<RoutingContext> var1);

    @Fluent
    public Route blockingHandler(Handler<RoutingContext> var1);

    @Fluent
    public Route subRouter(Router var1);

    @Fluent
    public Route blockingHandler(Handler<RoutingContext> var1, boolean var2);

    @Fluent
    public Route failureHandler(Handler<RoutingContext> var1);

    @Fluent
    public Route remove();

    @Fluent
    public Route disable();

    @Fluent
    public Route enable();

    @Fluent
    @Deprecated
    default public Route useNormalisedPath(boolean useNormalizedPath) {
        return this.useNormalizedPath(useNormalizedPath);
    }

    @Fluent
    public Route useNormalizedPath(boolean var1);

    public @Nullable String getPath();

    public boolean isRegexPath();

    public Set<HttpMethod> methods();

    @Fluent
    public Route setRegexGroupsNames(List<String> var1);

    @Fluent
    public Route setName(String var1);

    public String getName();

    @Fluent
    default public <T> Route respond(Function<RoutingContext, Future<T>> function) {
        return this.handler((Handler<RoutingContext>)((Handler)ctx -> {
            try {
                ((Future)function.apply((RoutingContext)ctx)).onFailure(ctx::fail).onSuccess(body -> {
                    if (!ctx.response().headWritten()) {
                        ctx.json(body);
                    } else if (body == null) {
                        if (!ctx.response().ended()) {
                            ctx.end();
                        }
                    } else {
                        ctx.fail(new HttpStatusException(500, "Response already written"));
                    }
                });
            }
            catch (RuntimeException e) {
                ctx.fail(e);
            }
        }));
    }
}

