/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.containers.engine;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.zeebe.client.ZeebeClient;
import io.camunda.zeebe.client.ZeebeClientBuilder;
import io.camunda.zeebe.client.api.JsonMapper;
import io.camunda.zeebe.client.impl.ZeebeObjectMapper;
import io.camunda.zeebe.process.test.api.RecordStreamSource;
import io.zeebe.containers.ZeebeNode;
import io.zeebe.containers.clock.ZeebeClock;
import io.zeebe.containers.cluster.ZeebeCluster;
import io.zeebe.containers.engine.DebugReceiverStream;
import io.zeebe.containers.engine.TestAwareContainerEngine;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeoutException;
import java.util.function.UnaryOperator;
import org.agrona.CloseHelper;
import org.apiguardian.api.API;

@API(status=API.Status.INTERNAL)
final class ZeebeClusterEngine
implements TestAwareContainerEngine {
    private final List<ZeebeClient> clients = new ArrayList<ZeebeClient>();
    private final DebugReceiverStream recordStream;
    private final ZeebeCluster cluster;
    private final Collection<ZeebeClock> clocks;

    public ZeebeClusterEngine(ZeebeCluster cluster, DebugReceiverStream recordStream) {
        this.cluster = cluster;
        this.recordStream = recordStream;
        this.clocks = new ArrayList<ZeebeClock>();
        for (ZeebeNode node : cluster.getNodes().values()) {
            node.withEnv("ZEEBE_CLOCK_CONTROLLED", "true");
            this.clocks.add(ZeebeClock.newDefaultClock((ZeebeNode)node));
        }
    }

    @Override
    public void acknowledge(int partitionId, long position) {
        this.recordStream.acknowledge(partitionId, position);
    }

    public RecordStreamSource getRecordStreamSource() {
        return this.recordStream;
    }

    public ZeebeClient createClient() {
        return this.createClient(UnaryOperator.identity());
    }

    public ZeebeClient createClient(ObjectMapper customObjectMapper) {
        return this.createClient(b -> b.withJsonMapper((JsonMapper)new ZeebeObjectMapper(customObjectMapper)));
    }

    public String getGatewayAddress() {
        return this.cluster.getAvailableGateway().getExternalGatewayAddress();
    }

    public void increaseTime(Duration timeToAdd) {
        this.clocks.forEach(clock -> clock.addTime(timeToAdd));
    }

    public void waitForIdleState(Duration timeout) throws InterruptedException, TimeoutException {
        this.recordStream.waitForIdleState(timeout);
    }

    public void waitForBusyState(Duration timeout) throws InterruptedException, TimeoutException {
        this.recordStream.waitForBusyState(timeout);
    }

    public void start() {
        this.recordStream.start(this.cluster.getBrokers().values());
        this.cluster.start();
    }

    public void stop() {
        CloseHelper.closeAll(this.clients);
        this.clients.clear();
        CloseHelper.closeAll((AutoCloseable[])new AutoCloseable[]{this.cluster, this.recordStream});
    }

    private ZeebeClient createClient(UnaryOperator<ZeebeClientBuilder> configurator) {
        ZeebeClientBuilder builder = (ZeebeClientBuilder)configurator.apply(ZeebeClient.newClientBuilder().usePlaintext().gatewayAddress(this.getGatewayAddress()));
        ZeebeClient client = builder.build();
        this.clients.add(client);
        return client;
    }
}

