/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.containers.engine;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.zeebe.client.ZeebeClient;
import io.camunda.zeebe.client.ZeebeClientBuilder;
import io.camunda.zeebe.client.api.JsonMapper;
import io.camunda.zeebe.client.impl.ZeebeObjectMapper;
import io.camunda.zeebe.process.test.api.RecordStreamSource;
import io.zeebe.containers.ZeebeBrokerNode;
import io.zeebe.containers.ZeebeGatewayNode;
import io.zeebe.containers.ZeebeNode;
import io.zeebe.containers.clock.ZeebeClock;
import io.zeebe.containers.engine.DebugReceiverStream;
import io.zeebe.containers.engine.TestAwareContainerEngine;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeoutException;
import java.util.function.UnaryOperator;
import org.agrona.CloseHelper;
import org.apiguardian.api.API;
import org.testcontainers.containers.GenericContainer;

@API(status=API.Status.INTERNAL)
final class ZeebeContainerEngine<T extends GenericContainer<T> & ZeebeBrokerNode<T>>
implements TestAwareContainerEngine {
    private final List<ZeebeClient> clients = new ArrayList<ZeebeClient>();
    private final DebugReceiverStream recordStream;
    private final T container;
    private final ZeebeClock clock;

    ZeebeContainerEngine(T container, DebugReceiverStream recordStream) {
        this.container = container.withEnv("ZEEBE_CLOCK_CONTROLLED", "true");
        this.recordStream = recordStream;
        this.clock = ZeebeClock.newDefaultClock((ZeebeNode)((ZeebeNode)container));
    }

    @Override
    public void acknowledge(int partitionId, long position) {
        this.recordStream.acknowledge(partitionId, position);
    }

    public RecordStreamSource getRecordStreamSource() {
        return this.recordStream;
    }

    public ZeebeClient createClient() {
        return this.createClient(UnaryOperator.identity());
    }

    public ZeebeClient createClient(ObjectMapper objectMapper) {
        return this.createClient(b -> b.withJsonMapper((JsonMapper)new ZeebeObjectMapper(objectMapper)));
    }

    public String getGatewayAddress() {
        return ((ZeebeGatewayNode)this.container).getExternalGatewayAddress();
    }

    public void increaseTime(Duration timeToAdd) {
        this.clock.addTime(timeToAdd);
    }

    public void waitForIdleState(Duration timeout) throws InterruptedException, TimeoutException {
        this.recordStream.waitForIdleState(timeout);
    }

    public void waitForBusyState(Duration timeout) throws InterruptedException, TimeoutException {
        this.recordStream.waitForBusyState(timeout);
    }

    public void start() {
        this.recordStream.start(Collections.singleton(this.container));
        this.container.start();
    }

    public void stop() {
        CloseHelper.closeAll(this.clients);
        this.clients.clear();
        CloseHelper.closeAll((AutoCloseable[])new AutoCloseable[]{this.container, this.recordStream});
    }

    private ZeebeClient createClient(UnaryOperator<ZeebeClientBuilder> configurator) {
        ZeebeClientBuilder builder = (ZeebeClientBuilder)configurator.apply(ZeebeClient.newClientBuilder().usePlaintext().gatewayAddress(this.getGatewayAddress()));
        ZeebeClient client = builder.build();
        this.clients.add(client);
        return client;
    }
}

