/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.renderkit.html_basic;

import com.sun.faces.util.HtmlUtils;
import com.sun.faces.util.MessageUtils;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.ResponseWriter;

public class HtmlResponseWriter
extends ResponseWriter {
    private String contentType = "text/html";
    private String encoding = null;
    private Writer writer = null;
    private boolean closeStart;
    private boolean dontEscape;
    private char[] buffer = new char[1028];
    private char[] charHolder = new char[1];

    public HtmlResponseWriter(Writer writer, String contentType, String encoding) throws FacesException {
        this.writer = writer;
        if (null != contentType) {
            this.contentType = contentType;
        }
        this.encoding = encoding;
        try {
            HtmlUtils.validateEncoding(encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(MessageUtils.getExceptionMessageString("com.sun.faces.ENCODING_ERROR", new Object[0]));
        }
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getCharacterEncoding() {
        return this.encoding;
    }

    public void startDocument() throws IOException {
    }

    public void endDocument() throws IOException {
        this.writer.flush();
    }

    public void flush() throws IOException {
        this.closeStartIfNecessary();
    }

    public void startElement(String name, UIComponent componentForElement) throws IOException {
        if (name == null) {
            throw new NullPointerException(MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", new Object[0]));
        }
        this.closeStartIfNecessary();
        char firstChar = name.charAt(0);
        if ((firstChar == 's' || firstChar == 'S') && ("script".equalsIgnoreCase(name) || "style".equalsIgnoreCase(name))) {
            this.dontEscape = true;
        }
        this.writer.write(60);
        this.writer.write(name);
        this.closeStart = true;
    }

    public void endElement(String name) throws IOException {
        if (name == null) {
            throw new NullPointerException(MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", new Object[0]));
        }
        this.dontEscape = false;
        if (this.closeStart) {
            boolean isEmptyElement = HtmlUtils.isEmptyElement(name);
            if (isEmptyElement) {
                this.writer.write(" />");
                this.closeStart = false;
                return;
            }
            this.writer.write(62);
            this.closeStart = false;
        }
        this.writer.write("</");
        this.writer.write(name);
        this.writer.write(62);
    }

    public void writeAttribute(String name, Object value, String componentPropertyName) throws IOException {
        if (name == null) {
            throw new NullPointerException(MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", new Object[0]));
        }
        if (value == null) {
            return;
        }
        Class<?> valueClass = value.getClass();
        if (valueClass == Boolean.class) {
            if (Boolean.TRUE.equals(value)) {
                this.writer.write(32);
                this.writer.write(name);
                this.writer.write("=\"");
                this.writer.write(name);
                this.writer.write(34);
            }
        } else {
            this.writer.write(32);
            this.writer.write(name);
            this.writer.write("=\"");
            HtmlUtils.writeAttribute(this.writer, this.buffer, value.toString());
            this.writer.write(34);
        }
    }

    public void writeURIAttribute(String name, Object value, String componentPropertyName) throws IOException {
        if (name == null || value == null) {
            throw new NullPointerException(MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", new Object[0]));
        }
        this.writer.write(32);
        this.writer.write(name);
        this.writer.write("=\"");
        String stringValue = value.toString();
        if (stringValue.startsWith("javascript:")) {
            HtmlUtils.writeAttribute(this.writer, this.buffer, stringValue);
        } else {
            HtmlUtils.writeURL(this.writer, stringValue, this.encoding);
        }
        this.writer.write(34);
    }

    public void writeComment(Object comment) throws IOException {
        if (comment == null) {
            throw new NullPointerException(MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", new Object[0]));
        }
        this.closeStartIfNecessary();
        this.writer.write("<!--");
        this.writer.write(comment.toString());
        this.writer.write("-->");
    }

    public void writeText(Object text, String componentPropertyName) throws IOException {
        if (text == null) {
            throw new NullPointerException(MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", new Object[0]));
        }
        this.closeStartIfNecessary();
        if (this.dontEscape) {
            this.writer.write(text.toString());
        } else {
            HtmlUtils.writeText(this.writer, this.buffer, text.toString());
        }
    }

    public void writeText(char text) throws IOException {
        this.closeStartIfNecessary();
        if (this.dontEscape) {
            this.writer.write(text);
        } else {
            this.charHolder[0] = text;
            HtmlUtils.writeText(this.writer, this.buffer, this.charHolder);
        }
    }

    public void writeText(char[] text) throws IOException {
        if (text == null) {
            throw new NullPointerException(MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", new Object[0]));
        }
        this.closeStartIfNecessary();
        if (this.dontEscape) {
            this.writer.write(text);
        } else {
            HtmlUtils.writeText(this.writer, this.buffer, text);
        }
    }

    public void writeText(char[] text, int off, int len) throws IOException {
        if (text == null) {
            throw new NullPointerException(MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", new Object[0]));
        }
        if (off < 0 || off > text.length || len < 0 || len > text.length) {
            throw new IndexOutOfBoundsException();
        }
        this.closeStartIfNecessary();
        if (this.dontEscape) {
            this.writer.write(text, off, len);
        } else {
            HtmlUtils.writeText(this.writer, this.buffer, text, off, len);
        }
    }

    public ResponseWriter cloneWithWriter(Writer writer) {
        try {
            return new HtmlResponseWriter(writer, this.getContentType(), this.getCharacterEncoding());
        }
        catch (FacesException e) {
            throw new IllegalStateException();
        }
    }

    private void closeStartIfNecessary() throws IOException {
        if (this.closeStart) {
            this.writer.write(62);
            this.closeStart = false;
        }
    }

    public void close() throws IOException {
        this.closeStartIfNecessary();
        this.writer.close();
    }

    public void write(char cbuf) throws IOException {
        this.closeStartIfNecessary();
        this.writer.write(cbuf);
    }

    public void write(char[] cbuf, int off, int len) throws IOException {
        this.closeStartIfNecessary();
        this.writer.write(cbuf, off, len);
    }

    public void write(int c) throws IOException {
        this.closeStartIfNecessary();
        this.writer.write(c);
    }

    public void write(String str) throws IOException {
        this.closeStartIfNecessary();
        this.writer.write(str);
    }

    public void write(String str, int off, int len) throws IOException {
        this.closeStartIfNecessary();
        this.writer.write(str, off, len);
    }
}

