/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.application;

import com.sun.faces.RIConstants;
import com.sun.faces.application.ApplicationAssociate;
import com.sun.faces.application.ConverterPropertyEditorBase;
import com.sun.faces.application.ConverterPropertyEditorFactory;
import com.sun.faces.application.MethodBindingMethodExpressionAdapter;
import com.sun.faces.application.NavigationHandlerImpl;
import com.sun.faces.application.ValueBindingValueExpressionAdapter;
import com.sun.faces.config.WebConfiguration;
import com.sun.faces.el.ELUtils;
import com.sun.faces.el.FacesCompositeELResolver;
import com.sun.faces.el.PropertyResolverImpl;
import com.sun.faces.el.VariableResolverImpl;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.MessageUtils;
import com.sun.faces.util.ReflectionUtils;
import com.sun.faces.util.Util;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.lang.reflect.Constructor;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.CompositeELResolver;
import javax.el.ELContextListener;
import javax.el.ELException;
import javax.el.ELResolver;
import javax.el.ExpressionFactory;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.application.Application;
import javax.faces.application.NavigationHandler;
import javax.faces.application.StateManager;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.el.MethodBinding;
import javax.faces.el.PropertyResolver;
import javax.faces.el.ReferenceSyntaxException;
import javax.faces.el.ValueBinding;
import javax.faces.el.VariableResolver;
import javax.faces.event.ActionListener;
import javax.faces.validator.Validator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationImpl
extends Application {
    private static final Logger logger = FacesLogger.APPLICATION.getLogger();
    private static final ELContextListener[] EMPTY_EL_CTX_LIST_ARRAY = new ELContextListener[0];
    private static final Map<String, Class<?>[]> STANDARD_CONV_ID_TO_TYPE_MAP = new HashMap<String, Class<?>[]>(8, 1.0f);
    private static final Map<Class<?>, String> STANDARD_TYPE_TO_CONV_ID_MAP = new HashMap(16, 1.0f);
    private ApplicationAssociate associate = null;
    private volatile ActionListener actionListener = null;
    private volatile NavigationHandler navigationHandler = null;
    private volatile PropertyResolverImpl propertyResolver = null;
    private volatile VariableResolverImpl variableResolver = null;
    private volatile ViewHandler viewHandler = null;
    private volatile StateManager stateManager = null;
    private volatile ArrayList<Locale> supportedLocales = null;
    private volatile Locale defaultLocale = null;
    private Map<String, Object> componentMap = null;
    private Map<String, Object> converterIdMap = null;
    private Map<Class, Object> converterTypeMap = null;
    private Map<String, Object> validatorMap = null;
    private volatile String messageBundle = null;
    private ArrayList<ELContextListener> elContextListeners = null;
    private ArrayList<ELResolver> elResolvers = null;
    private CompositeELResolver compositeELResolver = null;
    private boolean registerPropertyEditors;
    private final String[] STANDARD_BY_TYPE_CONVERTER_CLASSES = new String[]{"java.math.BigDecimal", "java.lang.Boolean", "java.lang.Byte", "java.lang.Character", "java.lang.Double", "java.lang.Float", "java.lang.Integer", "java.lang.Long", "java.lang.Short", "java.lang.Enum"};
    protected String defaultRenderKitId = null;

    public ApplicationImpl() {
        this.associate = new ApplicationAssociate(this);
        this.componentMap = new ConcurrentHashMap<String, Object>();
        this.converterIdMap = new ConcurrentHashMap<String, Object>();
        this.converterTypeMap = new ConcurrentHashMap<Class, Object>();
        this.validatorMap = new ConcurrentHashMap<String, Object>();
        this.navigationHandler = new NavigationHandlerImpl(this.associate);
        this.propertyResolver = new PropertyResolverImpl();
        this.variableResolver = new VariableResolverImpl();
        WebConfiguration webConfig = WebConfiguration.getInstance();
        this.registerPropertyEditors = webConfig.isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.RegisterConverterPropertyEditors);
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Created Application instance ");
        }
    }

    public void addELContextListener(ELContextListener listener) {
        if (listener != null) {
            if (this.elContextListeners == null) {
                this.elContextListeners = new ArrayList();
            }
            this.elContextListeners.add(listener);
        }
    }

    public void removeELContextListener(ELContextListener listener) {
        if (listener != null && this.elContextListeners != null) {
            this.elContextListeners.remove(listener);
        }
    }

    public ELContextListener[] getELContextListeners() {
        if (this.elContextListeners != null) {
            return this.elContextListeners.toArray(new ELContextListener[this.elContextListeners.size()]);
        }
        return EMPTY_EL_CTX_LIST_ARRAY;
    }

    public ExpressionFactory getExpressionFactory() {
        return this.associate.getExpressionFactory();
    }

    public Object evaluateExpressionGet(FacesContext context, String expression, Class expectedType) throws ELException {
        ValueExpression ve = this.getExpressionFactory().createValueExpression(context.getELContext(), expression, expectedType);
        return ve.getValue(context.getELContext());
    }

    public UIComponent createComponent(ValueExpression componentExpression, FacesContext context, String componentType) throws FacesException {
        Object result;
        if (null == componentExpression) {
            String message = MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "componentExpression");
            throw new NullPointerException(message);
        }
        if (null == context) {
            String message = MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "context");
            throw new NullPointerException(message);
        }
        if (null == componentType) {
            String message = MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "componentType");
            throw new NullPointerException(message);
        }
        boolean createOne = false;
        try {
            result = componentExpression.getValue(context.getELContext());
            if (null != result) {
                boolean bl = createOne = !(result instanceof UIComponent);
            }
            if (null == result || createOne) {
                result = this.createComponent(componentType);
                componentExpression.setValue(context.getELContext(), result);
            }
        }
        catch (Exception ex) {
            throw new FacesException((Throwable)ex);
        }
        return (UIComponent)result;
    }

    public ELResolver getELResolver() {
        if (this.compositeELResolver == null) {
            this.compositeELResolver = new FacesCompositeELResolver(FacesCompositeELResolver.ELResolverChainType.Faces);
            ELUtils.buildFacesResolver(this.compositeELResolver, this.associate);
        }
        return this.compositeELResolver;
    }

    public void addELResolver(ELResolver resolver) {
        if (this.associate.hasRequestBeenServiced()) {
            throw new IllegalStateException(MessageUtils.getExceptionMessageString("com.sun.faces.APPLICATION_INIT_COMPLETE_ERROR_ID", new Object[0]));
        }
        if (this.elResolvers == null) {
            this.elResolvers = new ArrayList();
        }
        this.elResolvers.add(resolver);
    }

    public List<ELResolver> getApplicationELResolvers() {
        return this.elResolvers;
    }

    public ActionListener getActionListener() {
        return this.actionListener;
    }

    public ViewHandler getViewHandler() {
        return this.viewHandler;
    }

    public synchronized void setViewHandler(ViewHandler handler) {
        if (handler == null) {
            String message = MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "handler");
            throw new NullPointerException(message);
        }
        if (this.associate.isResponseRendered()) {
            if (logger.isLoggable(Level.SEVERE)) {
                logger.log(Level.SEVERE, "jsf.illegal_attempt_setting_viewhandler_error");
            }
            throw new IllegalStateException(MessageUtils.getExceptionMessageString("com.sun.faces.ILLEGAL_ATTEMPT_SETTING_VIEWHANDLER", new Object[0]));
        }
        this.viewHandler = handler;
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, MessageFormat.format("set ViewHandler Instance to ''{0}''", this.viewHandler.getClass().getName()));
        }
    }

    public StateManager getStateManager() {
        return this.stateManager;
    }

    public synchronized void setStateManager(StateManager manager) {
        if (manager == null) {
            String message = MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "manager");
            throw new NullPointerException(message);
        }
        if (this.associate.isResponseRendered()) {
            if (logger.isLoggable(Level.SEVERE)) {
                logger.log(Level.SEVERE, "jsf.illegal_attempt_setting_statemanager_error");
            }
            throw new IllegalStateException(MessageUtils.getExceptionMessageString("com.sun.faces.ILLEGAL_ATTEMPT_SETTING_STATEMANAGER", new Object[0]));
        }
        this.stateManager = manager;
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, MessageFormat.format("set StateManager Instance to ''{0}''", this.stateManager.getClass().getName()));
        }
    }

    public synchronized void setActionListener(ActionListener listener) {
        if (listener == null) {
            String message = MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "listener");
            throw new NullPointerException(message);
        }
        this.actionListener = listener;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(MessageFormat.format("set ActionListener Instance to ''{0}''", this.actionListener.getClass().getName()));
        }
    }

    public NavigationHandler getNavigationHandler() {
        return this.navigationHandler;
    }

    public synchronized void setNavigationHandler(NavigationHandler handler) {
        if (handler == null) {
            String message = MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "handler");
            throw new NullPointerException(message);
        }
        this.navigationHandler = handler;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(MessageFormat.format("set NavigationHandler Instance to ''{0}''", this.navigationHandler.getClass().getName()));
        }
    }

    public PropertyResolver getPropertyResolver() {
        return this.propertyResolver;
    }

    public ResourceBundle getResourceBundle(FacesContext context, String var) {
        if (null == context || null == var) {
            throw new FacesException("context or var is null.");
        }
        return this.associate.getResourceBundle(context, var);
    }

    public void setPropertyResolver(PropertyResolver resolver) {
        if (this.associate.hasRequestBeenServiced()) {
            throw new IllegalStateException(MessageUtils.getExceptionMessageString("com.sun.faces.APPLICATION_INIT_COMPLETE_ERROR_ID", new Object[0]));
        }
        if (resolver == null) {
            String message = MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "resolver");
            throw new NullPointerException(message);
        }
        this.propertyResolver.setDelegate(ELUtils.getDelegatePR(this.associate, true));
        this.associate.setLegacyPropertyResolver(resolver);
        this.propertyResolver = new PropertyResolverImpl();
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(MessageFormat.format("set PropertyResolver Instance to ''{0}''", resolver.getClass().getName()));
        }
    }

    public MethodBinding createMethodBinding(String ref, Class[] params) {
        MethodExpression result;
        if (ref == null) {
            String message = MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "ref");
            throw new NullPointerException(message);
        }
        if (!ref.startsWith("#{") || !ref.endsWith("}")) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(MessageFormat.format("Expression ''{0}'' does not follow the syntax #{...}", ref));
            }
            throw new ReferenceSyntaxException(ref);
        }
        FacesContext context = FacesContext.getCurrentInstance();
        try {
            if (null == params) {
                params = RIConstants.EMPTY_CLASS_ARGS;
            }
            result = this.getExpressionFactory().createMethodExpression(context.getELContext(), ref, null, params);
        }
        catch (ELException elex) {
            throw new ReferenceSyntaxException((Throwable)elex);
        }
        return new MethodBindingMethodExpressionAdapter(result);
    }

    public ValueBinding createValueBinding(String ref) throws ReferenceSyntaxException {
        ValueExpression result;
        if (ref == null) {
            String message = MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "ref");
            throw new NullPointerException(message);
        }
        FacesContext context = FacesContext.getCurrentInstance();
        try {
            result = this.getExpressionFactory().createValueExpression(context.getELContext(), ref, Object.class);
        }
        catch (ELException elex) {
            throw new ReferenceSyntaxException((Throwable)elex);
        }
        return new ValueBindingValueExpressionAdapter(result);
    }

    public VariableResolver getVariableResolver() {
        return this.variableResolver;
    }

    public void setVariableResolver(VariableResolver resolver) {
        if (this.associate.hasRequestBeenServiced()) {
            throw new IllegalStateException(MessageUtils.getExceptionMessageString("com.sun.faces.APPLICATION_INIT_COMPLETE_ERROR_ID", new Object[0]));
        }
        if (resolver == null) {
            String message = MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "resolver");
            throw new NullPointerException(message);
        }
        this.variableResolver.setDelegate(ELUtils.getDelegateVR(this.associate, true));
        this.associate.setLegacyVariableResolver(resolver);
        this.variableResolver = new VariableResolverImpl();
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(MessageFormat.format("set VariableResolver Instance to ''{0}''", ((Object)((Object)this.variableResolver)).getClass().getName()));
        }
    }

    public void addComponent(String componentType, String componentClass) {
        if (componentType == null) {
            String message = MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "componentType");
            throw new NullPointerException(message);
        }
        if (componentClass == null) {
            String message = MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "componentClass");
            throw new NullPointerException(message);
        }
        this.componentMap.put(componentType, componentClass);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(MessageFormat.format("added component of type ''{0}'' and class ''{1}''", componentType, componentClass));
        }
    }

    public UIComponent createComponent(String componentType) throws FacesException {
        UIComponent returnVal;
        if (componentType == null) {
            String message = MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "componentType");
            throw new NullPointerException(message);
        }
        try {
            returnVal = (UIComponent)this.newThing(componentType, this.componentMap);
        }
        catch (Exception ex) {
            if (logger.isLoggable(Level.WARNING)) {
                logger.log(Level.WARNING, "jsf.cannot_instantiate_component_error", componentType);
            }
            throw new FacesException((Throwable)ex);
        }
        if (returnVal == null) {
            Object[] params = new Object[]{componentType};
            if (logger.isLoggable(Level.SEVERE)) {
                logger.log(Level.SEVERE, "jsf.cannot_instantiate_component_error", params);
            }
            throw new FacesException(MessageUtils.getExceptionMessageString("com.sun.faces.NAMED_OBJECT_NOT_FOUND_ERROR", params));
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, MessageFormat.format("Created component with component type of ''{0}''", componentType));
        }
        return returnVal;
    }

    public UIComponent createComponent(ValueBinding componentBinding, FacesContext context, String componentType) throws FacesException {
        Object result;
        if (null == componentBinding) {
            String message = MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "componentBinding");
            throw new NullPointerException(message);
        }
        if (null == context) {
            String message = MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "context");
            throw new NullPointerException(message);
        }
        if (null == componentType) {
            String message = MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "componentType");
            throw new NullPointerException(message);
        }
        boolean createOne = false;
        try {
            result = componentBinding.getValue(context);
            if (null != result) {
                boolean bl = createOne = !(result instanceof UIComponent);
            }
            if (null == result || createOne) {
                result = this.createComponent(componentType);
                componentBinding.setValue(context, result);
            }
        }
        catch (Exception ex) {
            throw new FacesException((Throwable)ex);
        }
        return (UIComponent)result;
    }

    public Iterator<String> getComponentTypes() {
        return this.componentMap.keySet().iterator();
    }

    public void addConverter(String converterId, String converterClass) {
        if (converterId == null) {
            String message = MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "converterId");
            throw new NullPointerException(message);
        }
        if (converterClass == null) {
            String message = MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "converterClass");
            throw new NullPointerException(message);
        }
        this.converterIdMap.put(converterId, converterClass);
        Class<?>[] types = STANDARD_CONV_ID_TO_TYPE_MAP.get(converterId);
        if (types != null) {
            for (Class<?> clazz : types) {
                this.converterTypeMap.put(clazz, converterClass);
                this.addPropertyEditorIfNecessary(clazz);
            }
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(MessageFormat.format("added converter of type ''{0}'' and class ''{1}''", converterId, converterClass));
        }
    }

    public void addConverter(Class targetClass, String converterClass) {
        if (targetClass == null) {
            String message = MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "targetClass");
            throw new NullPointerException(message);
        }
        if (converterClass == null) {
            String message = MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "converterClass");
            throw new NullPointerException(message);
        }
        String converterId = STANDARD_TYPE_TO_CONV_ID_MAP.get(targetClass);
        if (converterId != null) {
            this.addConverter(converterId, converterClass);
        } else {
            this.converterTypeMap.put(targetClass, converterClass);
            this.addPropertyEditorIfNecessary(targetClass);
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(MessageFormat.format("added converter of class type ''{0}''", converterClass));
        }
    }

    private void addPropertyEditorIfNecessary(Class targetClass) {
        if (!this.registerPropertyEditors) {
            return;
        }
        PropertyEditor editor = PropertyEditorManager.findEditor(targetClass);
        if (null != editor) {
            return;
        }
        String className = targetClass.getName();
        if (targetClass.isPrimitive()) {
            return;
        }
        for (String standardClass : this.STANDARD_BY_TYPE_CONVERTER_CLASSES) {
            if (-1 == standardClass.indexOf(className)) continue;
            return;
        }
        Class<? extends ConverterPropertyEditorBase> editorClass = ConverterPropertyEditorFactory.getDefaultInstance().definePropertyEditorClassFor(targetClass);
        if (editorClass != null) {
            PropertyEditorManager.registerEditor(targetClass, editorClass);
        } else if (logger.isLoggable(Level.WARNING)) {
            logger.warning(MessageFormat.format("definePropertyEditorClassFor({0}) returned null.", targetClass.getName()));
        }
    }

    public Converter createConverter(String converterId) {
        if (converterId == null) {
            String message = MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "convertedId");
            throw new NullPointerException(message);
        }
        Converter returnVal = (Converter)this.newThing(converterId, this.converterIdMap);
        if (returnVal == null) {
            Object[] params = new Object[]{converterId};
            if (logger.isLoggable(Level.SEVERE)) {
                logger.log(Level.SEVERE, "jsf.cannot_instantiate_converter_error", converterId);
            }
            throw new FacesException(MessageUtils.getExceptionMessageString("com.sun.faces.NAMED_OBJECT_NOT_FOUND_ERROR", params));
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(MessageFormat.format("created converter of type ''{0}''", converterId));
        }
        return returnVal;
    }

    public Converter createConverter(Class targetClass) {
        Class superclass;
        if (targetClass == null) {
            String message = MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "targetClass");
            throw new NullPointerException(message);
        }
        Converter returnVal = (Converter)this.newConverter(targetClass, this.converterTypeMap, targetClass);
        if (returnVal != null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(MessageFormat.format("Created converter of type ''{0}''", returnVal.getClass().getName()));
            }
            return returnVal;
        }
        Class<?>[] interfaces = targetClass.getInterfaces();
        if (interfaces != null) {
            for (int i = 0; i < interfaces.length; ++i) {
                returnVal = this.createConverterBasedOnClass(interfaces[i], targetClass);
                if (returnVal == null) continue;
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine(MessageFormat.format("Created converter of type ''{0}''", returnVal.getClass().getName()));
                }
                return returnVal;
            }
        }
        if ((superclass = targetClass.getSuperclass()) != null && (returnVal = this.createConverterBasedOnClass(superclass, targetClass)) != null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(MessageFormat.format("Created converter of type ''{0}''", returnVal.getClass().getName()));
            }
            return returnVal;
        }
        return returnVal;
    }

    protected Converter createConverterBasedOnClass(Class targetClass, Class baseClass) {
        Class superclass;
        Converter returnVal = (Converter)this.newConverter(targetClass, this.converterTypeMap, baseClass);
        if (returnVal != null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(MessageFormat.format("Created converter of type ''{0}''", returnVal.getClass().getName()));
            }
            return returnVal;
        }
        Class<?>[] interfaces = targetClass.getInterfaces();
        if (interfaces != null) {
            for (int i = 0; i < interfaces.length; ++i) {
                returnVal = this.createConverterBasedOnClass(interfaces[i], null);
                if (returnVal == null) continue;
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine(MessageFormat.format("Created converter of type ''{0}''", returnVal.getClass().getName()));
                }
                return returnVal;
            }
        }
        if ((superclass = targetClass.getSuperclass()) != null && (returnVal = this.createConverterBasedOnClass(superclass, null)) != null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(MessageFormat.format("Created converter of type ''{0}''", returnVal.getClass().getName()));
            }
            return returnVal;
        }
        return returnVal;
    }

    public Iterator<String> getConverterIds() {
        return this.converterIdMap.keySet().iterator();
    }

    public Iterator<Class> getConverterTypes() {
        return this.converterTypeMap.keySet().iterator();
    }

    public Iterator<Locale> getSupportedLocales() {
        if (null != this.supportedLocales) {
            return this.supportedLocales.iterator();
        }
        return Collections.emptyList().iterator();
    }

    public synchronized void setSupportedLocales(Collection<Locale> newLocales) {
        if (null == newLocales) {
            String message = MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "newLocales");
            throw new NullPointerException(message);
        }
        this.supportedLocales = new ArrayList<Locale>(newLocales);
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, MessageFormat.format("set Supported Locales ''{0}''", this.supportedLocales.toString()));
        }
    }

    public Locale getDefaultLocale() {
        return this.defaultLocale;
    }

    public synchronized void setDefaultLocale(Locale locale) {
        if (locale == null) {
            String message = MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "locale");
            throw new NullPointerException(message);
        }
        this.defaultLocale = locale;
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, MessageFormat.format("set defaultLocale ''{0}''", this.defaultLocale.getClass().getName()));
        }
    }

    public String getDefaultRenderKitId() {
        return this.defaultRenderKitId;
    }

    public void setDefaultRenderKitId(String renderKitId) {
        this.defaultRenderKitId = renderKitId;
    }

    public void addValidator(String validatorId, String validatorClass) {
        if (validatorId == null) {
            String message = MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "validatorId");
            throw new NullPointerException(message);
        }
        if (validatorClass == null) {
            String message = MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "validatorClass");
            throw new NullPointerException(message);
        }
        this.validatorMap.put(validatorId, validatorClass);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(MessageFormat.format("added validator of type ''{0}'' class ''{1}''", validatorId, validatorClass));
        }
    }

    public Validator createValidator(String validatorId) throws FacesException {
        if (validatorId == null) {
            String message = MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "validatorId");
            throw new NullPointerException(message);
        }
        Validator returnVal = (Validator)this.newThing(validatorId, this.validatorMap);
        if (returnVal == null) {
            Object[] params = new Object[]{validatorId};
            if (logger.isLoggable(Level.SEVERE)) {
                logger.log(Level.SEVERE, "jsf.cannot_instantiate_validator_error", params);
            }
            throw new FacesException(MessageUtils.getExceptionMessageString("com.sun.faces.NAMED_OBJECT_NOT_FOUND_ERROR", params));
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(MessageFormat.format("created validator of type ''{0}''", validatorId));
        }
        return returnVal;
    }

    public Iterator<String> getValidatorIds() {
        return this.validatorMap.keySet().iterator();
    }

    public synchronized void setMessageBundle(String messageBundle) {
        this.messageBundle = messageBundle;
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, MessageFormat.format("set messageBundle ''{0}''", messageBundle));
        }
    }

    public String getMessageBundle() {
        return this.messageBundle;
    }

    protected Object newThing(String key, Map<String, Object> map) {
        Object result;
        Class clazz;
        block10: {
            assert (key != null && map != null);
            clazz = null;
            Object value = map.get(key);
            if (value == null) {
                return null;
            }
            assert (value instanceof String || value instanceof Class);
            if (value instanceof String) {
                String cValue = (String)value;
                try {
                    clazz = Util.loadClass(cValue, value);
                    if (!this.associate.isDevModeEnabled()) {
                        map.put(key, clazz);
                    }
                    assert (clazz != null);
                    break block10;
                }
                catch (Throwable t) {
                    throw new FacesException(t.getMessage(), t);
                }
            }
            clazz = (Class)value;
        }
        try {
            result = clazz.newInstance();
        }
        catch (Throwable t) {
            throw new FacesException(MessageUtils.getExceptionMessageString("com.sun.faces.CANT_INSTANTIATE_CLASS", clazz.getName()), t);
        }
        return result;
    }

    protected Object newConverter(Class key, Map<Class, Object> map, Class targetClass) {
        Class clazz;
        Object result;
        block15: {
            assert (key != null && map != null);
            result = null;
            clazz = null;
            Object value = map.get(key);
            if (value == null) {
                return null;
            }
            assert (value instanceof String || value instanceof Class);
            if (value instanceof String) {
                String cValue = (String)value;
                try {
                    clazz = Util.loadClass(cValue, value);
                    if (!this.associate.isDevModeEnabled()) {
                        map.put(key, clazz);
                    }
                    assert (clazz != null);
                    break block15;
                }
                catch (Throwable t) {
                    throw new FacesException(t.getMessage(), t);
                }
            }
            clazz = (Class)value;
        }
        Constructor ctor = ReflectionUtils.lookupConstructor(clazz, Class.class);
        Exception cause = null;
        if (ctor != null) {
            try {
                result = ctor.newInstance(targetClass);
            }
            catch (Exception e) {
                cause = e;
            }
        } else {
            try {
                result = clazz.newInstance();
            }
            catch (Exception e) {
                cause = e;
            }
        }
        if (null != cause) {
            throw new FacesException(MessageUtils.getExceptionMessageString("com.sun.faces.CANT_INSTANTIATE_CLASS", clazz.getName()), (Throwable)cause);
        }
        return result;
    }

    static {
        STANDARD_CONV_ID_TO_TYPE_MAP.put("javax.faces.Byte", new Class[]{Byte.TYPE, Byte.class});
        STANDARD_CONV_ID_TO_TYPE_MAP.put("javax.faces.Boolean", new Class[]{Boolean.TYPE, Boolean.class});
        STANDARD_CONV_ID_TO_TYPE_MAP.put("javax.faces.Character", new Class[]{Character.TYPE, Character.class});
        STANDARD_CONV_ID_TO_TYPE_MAP.put("javax.faces.Short", new Class[]{Short.TYPE, Short.class});
        STANDARD_CONV_ID_TO_TYPE_MAP.put("javax.faces.Integer", new Class[]{Integer.TYPE, Integer.class});
        STANDARD_CONV_ID_TO_TYPE_MAP.put("javax.faces.Long", new Class[]{Long.TYPE, Long.class});
        STANDARD_CONV_ID_TO_TYPE_MAP.put("javax.faces.Float", new Class[]{Float.TYPE, Float.class});
        STANDARD_CONV_ID_TO_TYPE_MAP.put("javax.faces.Double", new Class[]{Double.TYPE, Double.class});
        for (Map.Entry<String, Class<?>[]> entry : STANDARD_CONV_ID_TO_TYPE_MAP.entrySet()) {
            Class<?>[] types = entry.getValue();
            String key = entry.getKey();
            for (Class<?> clazz : types) {
                STANDARD_TYPE_TO_CONV_ID_MAP.put(clazz, key);
            }
        }
    }
}

