/*
 *   @(#) AppendMerge.java 1.3 - last change made 08/21/03
 *
 * Copyright (c) 2001 Sun Microsystems, Inc. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 *
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 */

package javax.help;

import javax.swing.tree.*;
import java.util.*;
import java.text.*;

/**
 * Append merge type
 *
 * @author Richard Gregor
 * @version	1.3	08/21/03
 */
public class AppendMerge extends Merge{

    /**
     * Constructs AppendMerge
     *
     * @param master The master NavigatorView
     * @param slave The slave NavigatorView
     */ 
    public AppendMerge(NavigatorView master, NavigatorView slave){
        super(master,slave);

    }
    
    /**
     * Processes append merge
     *
     * @param node The master node
     * @return Merged master node
     */
    public TreeNode processMerge(TreeNode node){
       debug("start merge");

       mergeNodes(node, slaveTopNode);
       return node;
    }


    /**
     * Merge Nodes. Merge two nodes according to the Append merging rules 
     *
     * @param masterNode The master node to merge with 
     * @param slaveNode The node to merge into the master
     */
    public static void mergeNodes(TreeNode master, TreeNode slave) {
       DefaultMutableTreeNode masterNode = (DefaultMutableTreeNode)master;
       DefaultMutableTreeNode slaveNode = (DefaultMutableTreeNode)slave;
       debug("mergeNodes master=" + MergeHelpUtilities.getNodeName(masterNode) + 
	     " slave=" + MergeHelpUtilities.getNodeName(slaveNode));       
       while (slaveNode.getChildCount() > 0) {
	   DefaultMutableTreeNode slaveNodeChild = 
	       (DefaultMutableTreeNode)slaveNode.getFirstChild();
	   masterNode.add(slaveNodeChild);
	   MergeHelpUtilities.mergeNodeChildren("javax.help.AppendMerge", 
						slaveNodeChild);
       }
    }
    
    /**
     * Merge Node Children. Merge the children of a node according to the
     * Append merging.
     *
     * @param node The parent node from which the children are merged
     */
    public static void mergeNodeChildren(TreeNode node) {
	DefaultMutableTreeNode masterNode = (DefaultMutableTreeNode)node;
	debug("mergeNodes master=" + MergeHelpUtilities.getNodeName(masterNode));
	
	// The rules are there are no rules. Nothing else needs to be done
	// except for merging through the children
	for (int i=0; i < masterNode.getChildCount(); i++) {
	    DefaultMutableTreeNode child = 
		(DefaultMutableTreeNode)masterNode.getChildAt(i);
	    if (!child.isLeaf()) {
		MergeHelpUtilities.mergeNodeChildren("javax.help.AppendMerge",
						     child);
	    }
	}
    }

    private static boolean debug = false;
    private static void debug(String msg){
        if (debug) {
            System.out.println("AppendMerge :"+msg);
	}
    }
}
    
