/*
 *   @(#) NoMerge.java 1.2 - last change made 08/21/03
 *
 * Copyright (c) 2001 Sun Microsystems, Inc. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 *
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 */

package javax.help;

import javax.swing.tree.*;
import java.util.*;
import java.text.*;

/**
 * No merge type
 *
 * @author Roger Brinkley
 * @version	1.2	08/21/03
 */
public class NoMerge extends Merge{

    /**
     * Constructs NoMerge
     *
     * @param master The master NavigatorView
     * @param slave The slave NavigatorView
     */ 
    public NoMerge(NavigatorView master, NavigatorView slave){
        super(master,slave);

    }
    
    /**
     * Processes no merge
     *
     * @param node The master node
     * @return the master node
     */
    public TreeNode processMerge(TreeNode node){
       debug("start merge");
       DefaultMutableTreeNode masterNode = (DefaultMutableTreeNode)node;
 
       // There is no merging here but we will make sure
       // the master children are handled correctly
       MergeHelpUtilities.mergeNodeChildren("javax.help.NoMerge",
					    masterNode);      
       return masterNode;
    }
    
    /**
     * Merge Nodes. Merge two nodes according to the merging rules of the
     * masterNode. Each Subclass should override this implementation.
     *
     * @param master The master node to merge with 
     * @param slave The node to merge into the master
     */
    public static void mergeNodes(TreeNode master, TreeNode slave) {
	// Doesn't do anything
    }

    /**
     * Merge Node Children. Merge the children of a node according to the
     * merging rules of the parent. Each subclass must implement this method
     *
     * @param node The parent node from which the children are merged
     */
    public static void mergeNodeChildren(TreeNode node) {
	// Doesn't do anything
    }
    
    private static boolean debug = false;
    private static void debug(String msg){
        if (debug) {
            System.out.println("NoMerge :"+msg);
	}
    }
}
    
