/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.deb;

import java.util.List;
import org.apache.maven.project.Dependency;
import org.apache.maven.project.License;
import org.apache.maven.project.Project;

public final class ControlFile {
    private static final String[] FREE_LICENSES = new String[]{"gpl", "lgpl", "bsd", "artistic", "public domain"};
    private String packageName;
    private String version;
    private String section;
    private String priority;
    private String architecture;
    private String essential;
    private String depends;
    private String recommends;
    private String suggests;
    private String enhances;
    private String predepends;
    private String conflicts;
    private String replaces;
    private String provides;
    private String maintainer;
    private boolean nonUs;
    private Project project;
    private String license;
    private String description;
    private String debFileName;
    private String snapshot;
    private StringBuffer contents;
    private StringBuffer errors;

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    private String getPackageName() {
        return this.packageName;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    private String getVersion() {
        return this.version;
    }

    public void setSection(String section) {
        this.section = section;
    }

    private String getSection() {
        return this.section;
    }

    public void setPriority(String priority) {
        this.priority = priority;
    }

    private String getPriority() {
        return this.priority;
    }

    public void setArchitecture(String architecture) {
        this.architecture = architecture;
    }

    private String getArchitecture() {
        return this.architecture;
    }

    public void setEssential(String essential) {
        this.essential = essential;
    }

    private String getEssential() {
        return this.essential;
    }

    public void setDepends(String depends) {
        this.depends = depends;
    }

    private String getDepends() {
        return this.depends;
    }

    public void setRecommends(String recommends) {
        this.recommends = recommends;
    }

    private String getRecommends() {
        return this.recommends;
    }

    public void setSuggests(String suggests) {
        this.suggests = suggests;
    }

    private String getSuggests() {
        return this.suggests;
    }

    public void setEnhances(String enhances) {
        this.enhances = enhances;
    }

    private String getEnhances() {
        return this.enhances;
    }

    public void setPrepedends(String predepends) {
        this.predepends = predepends;
    }

    private String getPrepedends() {
        return this.predepends;
    }

    public void setConflicts(String conflicts) {
        this.conflicts = conflicts;
    }

    private String getConflicts() {
        return this.conflicts;
    }

    public void setReplaces(String replaces) {
        this.replaces = replaces;
    }

    private String getReplaces() {
        return this.replaces;
    }

    public void setProvides(String provides) {
        this.provides = provides;
    }

    private String getProvides() {
        return this.provides;
    }

    public void setMaintainer(String maintainer) {
        this.maintainer = maintainer;
    }

    private String getMaintainer() {
        return this.maintainer;
    }

    public void setNonUs(boolean nonUs) {
        this.nonUs = nonUs;
    }

    public boolean isNonUs() {
        return this.nonUs;
    }

    public void setLicense(String license) {
        this.license = license;
    }

    public String getLicense() {
        return this.license;
    }

    public void setProject(Project project) {
        this.project = project;
    }

    public void setDebFileName(String debFileName) {
        this.debFileName = debFileName;
    }

    public String getDebFileName() {
        return this.debFileName;
    }

    public void setSnapshot(String snapshot) {
        this.snapshot = snapshot.trim().length() == 0 ? null : snapshot;
    }

    public String getSnapshot() {
        return this.snapshot;
    }

    public void build() {
        int i;
        String tmp;
        List licenses;
        License license = null;
        this.contents = new StringBuffer();
        this.errors = new StringBuffer();
        if (this.project == null) {
            this.error("project must be set");
            return;
        }
        if (this.packageName == null) {
            this.packageName = this.project.getGroupId() == null ? this.project.getGroupId() + "-" + this.project.getArtifactId() : this.project.getArtifactId() + "-" + this.project.getArtifactId();
        }
        if (this.version == null) {
            this.version = this.snapshot == null ? this.project.getCurrentVersion() : this.project.getCurrentVersion() + "-" + this.snapshot;
        }
        if ((licenses = this.project.getLicenses()).size() > 0) {
            license = (License)licenses.get(0);
        }
        if (this.section == null) {
            if (license != null) {
                tmp = license.getName().trim().toLowerCase();
                for (i = 0; i < FREE_LICENSES.length; ++i) {
                    if (!tmp.equals(FREE_LICENSES[i])) continue;
                    this.section = this.isNonUs() ? "non-us/free" : "free";
                }
                if (this.section == null) {
                    this.section = "non-free";
                }
            } else {
                this.section = "non-free";
            }
        }
        if (this.priority == null) {
            this.priority = "extra";
        }
        if (this.architecture == null) {
            this.architecture = "all";
        }
        if (this.essential == null) {
            this.essential = "no";
        }
        if (this.depends == null) {
            this.depends = "";
            List dependencies = this.project.getDependencies();
            for (i = 0; i < dependencies.size(); ++i) {
                Dependency dependency = (Dependency)dependencies.get(i);
                tmp = dependency.getProperty("deb.depends");
                if (tmp == null || !tmp.equals("true")) continue;
                if (i > 0) {
                    this.depends = this.depends + ", ";
                }
                this.depends = this.depends + dependency.getGroupId() + "-" + dependency.getArtifactId() + " ";
                this.depends = this.depends + "(=" + dependency.getVersion() + ")";
            }
        }
        if (this.maintainer == null) {
            this.error("The maintainer property must be set.");
            return;
        }
        tmp = this.project.getShortDescription().trim();
        this.description = tmp != null ? tmp : "MISSING SHORT DESCRIPTION";
        tmp = this.project.getDescription().trim();
        if (tmp != null) {
            this.description = this.description + "\n " + tmp;
        }
        if (this.debFileName == null) {
            this.debFileName = this.packageName + "-" + this.version + ".deb";
        }
        this.append("Package: " + this.packageName);
        this.append("Version: " + this.version);
        this.append("Section: " + this.section);
        this.append("Priority: " + this.priority);
        this.append("Architecture: " + this.architecture);
        this.append("Essential: " + this.essential);
        this.append("Depends: " + this.depends.trim());
        this.append("Recommends: " + this.recommends);
        this.append("Maintainer: " + this.maintainer);
        this.append("Description: " + this.description);
    }

    private void checkNotNull(Object obj, String name) {
        if (obj == null) {
            throw new NullPointerException(name + " cannot be null.");
        }
    }

    private void append(String line) {
        this.contents.append(line + "\n");
    }

    private void error(String line) {
        this.errors.append(line + "\n");
    }

    public String getErrors() {
        if (this.errors == null) {
            return "";
        }
        return this.errors.toString();
    }

    public String getContents() {
        if (this.contents == null) {
            return "";
        }
        return this.contents.toString();
    }
}

