/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.genapp;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Arrays;
import org.mevenide.context.IQueryContext;
import org.mevenide.environment.LocationFinderAggregator;
import org.mevenide.genapp.TemplateInfo;
import org.mevenide.properties.IPropertyResolver;

public class GenAppTemplateFinder {
    private IPropertyResolver props;
    private IQueryContext context;
    public static final String LOCATION_DEFAULT = "GenApp";
    public static final String LOCATION_USER = "User";
    public static final String LOCATION_ALL = "All";

    public GenAppTemplateFinder(IQueryContext cont) {
        this.context = cont;
        this.props = this.context.getResolver();
    }

    public TemplateInfo[] getTemplates(String type) {
        if (LOCATION_USER.equals(type)) {
            return this.readTemplates(this.getUserDir());
        }
        if (LOCATION_DEFAULT.equals(type)) {
            return this.readTemplates(this.getGenAppDir());
        }
        if (LOCATION_ALL.equals(type)) {
            TemplateInfo[] info1 = this.readTemplates(this.getGenAppDir());
            TemplateInfo[] info2 = this.readTemplates(this.getUserDir());
            TemplateInfo[] merged = new TemplateInfo[info1.length + info2.length];
            ArrayList<TemplateInfo> toReturn = new ArrayList<TemplateInfo>();
            toReturn.addAll(Arrays.asList(info1));
            toReturn.addAll(Arrays.asList(info2));
            return toReturn.toArray(merged);
        }
        throw new IllegalArgumentException("Wrong template type=" + type);
    }

    public TemplateInfo[] getTemplates(File customTemplateRootDir) {
        return this.readTemplates(customTemplateRootDir);
    }

    private File getGenAppDir() {
        FilenameFilter pluginFilter;
        LocationFinderAggregator finder = new LocationFinderAggregator(this.context);
        File pluginDir = new File(finder.getMavenPluginsDir());
        String[] plugins = pluginDir.list(pluginFilter = new FilenameFilter(){

            public boolean accept(File dir, String name) {
                File f = new File(dir, name);
                return f.isDirectory() && name.startsWith("maven-genapp-plugin-");
            }
        });
        if (plugins.length < 1) {
            return null;
        }
        if (plugins.length < 2) {
            return new File(new File(pluginDir, plugins[0]), "plugin-resources");
        }
        int found = 0;
        int p0 = "maven-genapp-plugin-".length();
        int p1 = plugins[0].indexOf(46);
        int f0 = Integer.parseInt(plugins[0].substring(p0, p1));
        int f1 = Integer.parseInt(plugins[0].substring(p1 + 1));
        for (int i = 1; i < plugins.length; ++i) {
            int v0 = Integer.parseInt(plugins[i].substring(p0, p1));
            int v1 = Integer.parseInt(plugins[i].substring(p1 + 1));
            if (v0 <= f0 && (v0 != f0 || v1 <= f1)) continue;
            found = i;
            f0 = v0;
            f1 = v1;
        }
        return new File(new File(pluginDir, plugins[found]), "plugin-resources");
    }

    private File getUserDir() {
        String str = this.props.getResolvedValue("maven.genapp.template.repository");
        return str != null ? new File(str) : null;
    }

    private TemplateInfo[] readTemplates(File dir) {
        if (dir != null && dir.exists() && dir.isDirectory()) {
            File[] f = dir.listFiles();
            int nonTemplates = 0;
            for (int i = 0; i < f.length; ++i) {
                if (this.isTemplateDir(f[i])) continue;
                f[i] = null;
                ++nonTemplates;
            }
            TemplateInfo[] c = new TemplateInfo[f.length - nonTemplates];
            int j = 0;
            for (int i = 0; i < f.length; ++i) {
                if (f[i] == null) continue;
                c[j++] = new TemplateInfo(f[i], this.context);
            }
            return c;
        }
        return new TemplateInfo[0];
    }

    private boolean isTemplateDir(File dir) {
        if (!dir.isDirectory()) {
            return false;
        }
        File res = new File(dir, "template-resources");
        if (!res.exists() || !res.isDirectory()) {
            return false;
        }
        res = new File(dir, "template.properties");
        return res.exists() && res.isFile();
    }
}

