/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.genapp;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.StringTokenizer;
import org.mevenide.context.IQueryContext;

public class TemplateInfo {
    private File directory;
    private IQueryContext context;
    private String[] params;
    private Properties templateProperties;

    TemplateInfo(File dir, IQueryContext cont) {
        this.directory = dir;
        this.context = cont;
    }

    public String getName() {
        return this.directory.getName();
    }

    public String getDisplayName() {
        return this.getName();
    }

    public File[] getRepackageRooots() {
        this.loadProperties();
        String key = "maven.genapp.repackage";
        String val = this.templateProperties.getProperty(key);
        if (val == null) {
            val = this.context.getResolver().getResolvedValue(key);
        }
        if (val != null) {
            StringTokenizer tok = new StringTokenizer(val, ",");
            int count = tok.countTokens();
            File[] toRet = new File[count];
            for (int i = 0; i < count; ++i) {
                toRet[i] = new File(this.directory, tok.nextToken());
            }
            return toRet;
        }
        return new File[0];
    }

    public String[] getParameters() {
        if (this.params == null) {
            this.loadProperties();
            String val = this.templateProperties.getProperty("maven.genapp.param");
            if (val == null) {
                val = this.context.getResolver().getResolvedValue("maven.genapp.param");
            }
            if (val != null) {
                StringTokenizer tok = new StringTokenizer(val, ",");
                int count = tok.countTokens();
                String[] toRet = new String[count];
                for (int i = 0; i < count; ++i) {
                    toRet[i] = tok.nextToken();
                }
                this.params = toRet;
            } else {
                this.params = new String[0];
            }
        }
        return this.params;
    }

    public String getDefaultValue(String parameter) {
        this.loadProperties();
        String key = "maven.genapp.default." + parameter;
        String val = this.templateProperties.getProperty(key);
        if (val == null) {
            val = this.context.getResolver().getResolvedValue(key);
        }
        return val;
    }

    public String getPromptText(String parameter) {
        this.loadProperties();
        String key = "maven.genapp.prompt." + parameter;
        String val = this.templateProperties.getProperty(key);
        if (val == null) {
            val = this.context.getResolver().getResolvedValue(key);
        }
        return val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadProperties() {
        if (this.templateProperties == null) {
            this.templateProperties = new Properties();
            InputStream stream = null;
            File file = new File(this.directory, "template.properties");
            if (file.exists()) {
                try {
                    stream = new BufferedInputStream(new FileInputStream(file));
                    this.templateProperties.load(stream);
                }
                catch (IOException exc) {
                }
                finally {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (IOException exc) {}
                    }
                }
            }
        }
    }
}

