/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.goals.grabber;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.mevenide.goals.grabber.IGoalsGrabber;

public abstract class AbstractGoalsGrabber
implements IGoalsGrabber {
    protected Map plugins;
    protected Map prereqs;
    protected Map descriptions = new HashMap();

    protected AbstractGoalsGrabber() {
        this.initMaps();
    }

    public void refresh() throws Exception {
        this.initMaps();
    }

    private void initMaps() {
        this.plugins = new HashMap();
        this.prereqs = new HashMap();
        this.descriptions = new HashMap();
    }

    protected void registerGoal(String fullyQualifiedGoalName, String properties) {
        this.registerGoalName(fullyQualifiedGoalName);
        this.registerGoalProperties(fullyQualifiedGoalName, properties);
    }

    protected void registerGoalName(String fullyQualifiedGoalName) {
        TreeSet<String> goals;
        StringTokenizer splittedGoal = new StringTokenizer(fullyQualifiedGoalName, ":", false);
        String plugin = splittedGoal.nextToken();
        String goalName = "(default)";
        if (splittedGoal.hasMoreTokens()) {
            goalName = splittedGoal.nextToken();
        }
        if ((goals = (TreeSet<String>)this.plugins.get(plugin)) == null) {
            goals = new TreeSet<String>();
            this.plugins.put(plugin, goals);
        }
        goals.add(goalName);
    }

    protected void registerGoalProperties(String fullyQualifiedGoalName, String properties) {
        int index1;
        int n = index1 = properties == null ? -1 : properties.indexOf(62);
        if (properties != null) {
            String description = "";
            if (index1 > 0) {
                description = properties.substring(0, index1);
                this.descriptions.put(fullyQualifiedGoalName, description);
            }
            if (index1 > -1 && index1 < properties.length() - 1) {
                String prereqsString = properties.substring(index1 + 1);
                StringTokenizer tok = new StringTokenizer(prereqsString, ",", false);
                String[] commaSeparatedPrereqs = new String[tok.countTokens()];
                int count = 0;
                while (tok.hasMoreTokens()) {
                    commaSeparatedPrereqs[count] = tok.nextToken();
                    ++count;
                }
                this.prereqs.put(fullyQualifiedGoalName, commaSeparatedPrereqs);
            }
        }
    }

    public String[] getPlugins() {
        return this.toStringArray(this.plugins.keySet());
    }

    public String[] getGoals(String plugin) {
        if (plugin == null || (Collection)this.plugins.get(plugin) == null) {
            return null;
        }
        return this.toStringArray((Collection)this.plugins.get(plugin));
    }

    protected boolean containsGoal(String fullyQualifiedGoalName) {
        Collection goals;
        StringTokenizer splittedGoal = new StringTokenizer(fullyQualifiedGoalName, ":", false);
        String plugin = splittedGoal.nextToken();
        String goalName = "(default)";
        if (splittedGoal.hasMoreTokens()) {
            goalName = splittedGoal.nextToken();
        }
        if ((goals = (Collection)this.plugins.get(plugin)) == null) {
            return false;
        }
        return goalName == null || goals.contains(goalName);
    }

    public String getOrigin(String fullyQualifiedGoalName) {
        return this.containsGoal(fullyQualifiedGoalName) ? this.getName() : null;
    }

    public String getDescription(String fullyQualifiedGoalName) {
        return (String)this.descriptions.get(fullyQualifiedGoalName);
    }

    public String[] getPrereqs(String fullyQualifiedGoalName) {
        return (String[])this.prereqs.get(fullyQualifiedGoalName);
    }

    protected String[] toStringArray(Collection stringCollection) {
        Object[] obj = new TreeSet(stringCollection).toArray();
        String[] strg = new String[obj.length];
        for (int i = 0; i < strg.length; ++i) {
            strg[i] = (String)obj[i];
        }
        return strg;
    }
}

