/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.goals.grabber;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mevenide.environment.ConfigUtils;
import org.mevenide.environment.ILocationFinder;
import org.mevenide.goals.grabber.AbstractGoalsGrabber;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserFactory;

public class DefaultGoalsGrabber
extends AbstractGoalsGrabber {
    private static Log log = LogFactory.getLog((Class)DefaultGoalsGrabber.class);
    private ILocationFinder finder;
    private XmlPullParserFactory factory = XmlPullParserFactory.newInstance();

    public DefaultGoalsGrabber() throws Exception {
        this(ConfigUtils.getDefaultLocationFinder());
    }

    public DefaultGoalsGrabber(ILocationFinder find) throws Exception {
        this.finder = find;
        this.refresh();
    }

    public String getName() {
        return "Plugin";
    }

    public void refresh() throws Exception {
        super.refresh();
        File goalsCache = new File(this.finder.getMavenPluginsDir(), "goals.cache");
        if (goalsCache.exists()) {
            log.debug((Object)("Grabbing goals from : " + goalsCache.getAbsolutePath()));
            Properties props = new Properties();
            props.load(new FileInputStream(goalsCache));
            Set<Object> fullyQualifiedGoalNames = props.keySet();
            Iterator<Object> iterator = fullyQualifiedGoalNames.iterator();
            while (iterator.hasNext()) {
                String goalName = (String)iterator.next();
                this.registerGoal(goalName, props.getProperty(goalName));
            }
        } else {
            log.debug((Object)("No goals.cache file found in : " + this.finder.getMavenPluginsDir()));
            this.loadFromDir(this.finder.getPluginJarsDir());
            this.loadFromDir(this.finder.getUserPluginsDir());
        }
    }

    private void loadFromDir(String dirStr) throws Exception {
        File pluginDir;
        if (dirStr != null && (pluginDir = new File(dirStr)).exists()) {
            File[] listFiles = pluginDir.listFiles();
            for (int i = 0; i < listFiles.length; ++i) {
                this.parsePluginJar(listFiles[i]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parsePluginJar(File pluginJar) throws Exception {
        XmlPullParser parser = this.factory.newPullParser();
        InputStreamReader reader = null;
        try {
            JarFile fil = new JarFile(pluginJar);
            ZipEntry entry = fil.getEntry("plugin.jelly");
            if (entry != null) {
                reader = new InputStreamReader(fil.getInputStream(entry));
                parser.setInput((Reader)reader);
                int eventType = parser.getEventType();
                while (eventType != 1) {
                    if (eventType == 2 && parser.getName().equals("goal")) {
                        String fullyQualifiedName = parser.getAttributeValue(null, "name");
                        String prereqs = parser.getAttributeValue(null, "prereqs");
                        String description = parser.getAttributeValue(null, "description");
                        this.registerGoal(fullyQualifiedName, description + ">" + prereqs);
                    }
                    eventType = parser.next();
                }
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }
}

