/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.goals.grabber;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.mevenide.goals.grabber.IGoalsGrabber;

public class GoalsGrabbersAggregator
implements IGoalsGrabber {
    private List goalsGrabbers = new ArrayList();

    public void refresh() throws Exception {
        Iterator iterator = this.goalsGrabbers.iterator();
        while (iterator.hasNext()) {
            IGoalsGrabber goalsGrabber = (IGoalsGrabber)iterator.next();
            goalsGrabber.refresh();
        }
    }

    public String getName() {
        return "Aggregator";
    }

    public String getOrigin(String fullyQualifiedGoalName) {
        String origin = null;
        for (int i = 0; i < this.goalsGrabbers.size() && (origin = ((IGoalsGrabber)this.goalsGrabbers.get(i)).getOrigin(fullyQualifiedGoalName)) == null; ++i) {
        }
        return origin;
    }

    public void addGoalsGrabber(IGoalsGrabber goalsGrabber) {
        this.goalsGrabbers.add(goalsGrabber);
    }

    public void removeGoalsGrabber(IGoalsGrabber goalsGrabber) {
        this.goalsGrabbers.remove(goalsGrabber);
    }

    public String getDescription(String fullyQualifiedGoalName) {
        String description = null;
        for (int i = 0; i < this.goalsGrabbers.size(); ++i) {
            description = ((IGoalsGrabber)this.goalsGrabbers.get(i)).getDescription(fullyQualifiedGoalName);
            if (description == null) continue;
            return description;
        }
        return description;
    }

    public String[] getGoals(String plugin) {
        String[] goals = null;
        for (int i = 0; i < this.goalsGrabbers.size(); ++i) {
            goals = ((IGoalsGrabber)this.goalsGrabbers.get(i)).getGoals(plugin);
            if (goals == null) continue;
            return goals;
        }
        return goals;
    }

    public String[] getPlugins() {
        String[] plugins = new String[]{};
        for (int i = 0; i < this.goalsGrabbers.size(); ++i) {
            String[] currentPlugins = ((IGoalsGrabber)this.goalsGrabbers.get(i)).getPlugins();
            String[] tmpArray = new String[plugins.length];
            System.arraycopy(plugins, 0, tmpArray, 0, plugins.length);
            plugins = new String[plugins.length + currentPlugins.length];
            System.arraycopy(currentPlugins, 0, plugins, 0, currentPlugins.length);
            System.arraycopy(tmpArray, 0, plugins, currentPlugins.length, tmpArray.length);
        }
        return plugins;
    }

    public String[] getPrereqs(String fullyQualifiedGoalName) {
        String[] prereqs = null;
        for (int i = 0; i < this.goalsGrabbers.size(); ++i) {
            prereqs = ((IGoalsGrabber)this.goalsGrabbers.get(i)).getPrereqs(fullyQualifiedGoalName);
            if (prereqs == null) continue;
            return prereqs;
        }
        return prereqs;
    }

    public List getGoalsGrabbers() {
        return this.goalsGrabbers;
    }

    public void setGoalsGrabbers(List grabbers) {
        this.goalsGrabbers = grabbers;
    }
}

