/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.goals.grabber;

import java.io.FileReader;
import java.io.Reader;
import org.mevenide.goals.grabber.AbstractGoalsGrabber;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserFactory;

public class ProjectGoalsGrabber
extends AbstractGoalsGrabber {
    private String mavenXmlFile;

    public String getName() {
        return "Project";
    }

    public void refresh() throws Exception {
        super.refresh();
        if (this.mavenXmlFile == null) {
            throw new Exception("maven.xml file hasnot been set. Unable to refresh goals.");
        }
        this.parseMavenXml();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseMavenXml() throws Exception {
        XmlPullParserFactory factory = XmlPullParserFactory.newInstance();
        XmlPullParser parser = factory.newPullParser();
        FileReader reader = null;
        try {
            reader = new FileReader(this.mavenXmlFile);
            parser.setInput((Reader)reader);
            int eventType = parser.getEventType();
            while (eventType != 1) {
                if (eventType == 2 && parser.getName().equals("goal")) {
                    String fullyQualifiedName = parser.getAttributeValue(null, "name");
                    String prereqs = parser.getAttributeValue(null, "prereqs");
                    String description = parser.getAttributeValue(null, "description");
                    this.registerGoal(fullyQualifiedName, description + ">" + prereqs);
                }
                eventType = parser.next();
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    public String getMavenXmlFile() {
        return this.mavenXmlFile;
    }

    public void setMavenXmlFile(String mavenXml) {
        this.mavenXmlFile = mavenXml;
    }
}

