/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.goals.manager;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mevenide.context.IQueryContext;
import org.mevenide.environment.ILocationFinder;
import org.mevenide.goals.grabber.DefaultGoalsGrabber;
import org.mevenide.goals.grabber.GoalsGrabbersAggregator;
import org.mevenide.goals.grabber.IGoalsGrabber;
import org.mevenide.goals.grabber.ProjectGoalsGrabber;

public final class GoalsGrabbersManager {
    private static Log log = LogFactory.getLog((Class)GoalsGrabbersManager.class);
    private static Map goalsGrabbers = new HashMap();
    private static WeakHashMap defaultGrabbers = new WeakHashMap();
    private static WeakHashMap grabbers = new WeakHashMap();
    private static DefaultGoalsGrabber defaultGoalsGrabber;

    private GoalsGrabbersManager() {
    }

    public static synchronized IGoalsGrabber getGoalsGrabber(String projectDescriptorPath) throws Exception {
        IGoalsGrabber aggregator;
        if (goalsGrabbers.get(projectDescriptorPath) == null) {
            aggregator = new GoalsGrabbersAggregator();
            ((GoalsGrabbersAggregator)aggregator).addGoalsGrabber(GoalsGrabbersManager.getDefaultGoalsGrabber());
            String mavenXmlPath = new File(new File(projectDescriptorPath).getParent(), "maven.xml").getAbsolutePath();
            if (new File(mavenXmlPath).exists()) {
                ProjectGoalsGrabber projectGoalsGrabber = new ProjectGoalsGrabber();
                projectGoalsGrabber.setMavenXmlFile(mavenXmlPath);
                ((GoalsGrabbersAggregator)aggregator).addGoalsGrabber(projectGoalsGrabber);
                log.debug((Object)"maven.xml not found. aggregator only aggregates defaultGoalsGrabber.");
            }
            goalsGrabbers.put(projectDescriptorPath, aggregator);
        }
        aggregator = (IGoalsGrabber)goalsGrabbers.get(projectDescriptorPath);
        aggregator.refresh();
        return aggregator;
    }

    public static synchronized IGoalsGrabber getDefaultGoalsGrabber() throws Exception {
        if (defaultGoalsGrabber == null) {
            defaultGoalsGrabber = new DefaultGoalsGrabber();
        }
        return defaultGoalsGrabber;
    }

    public static synchronized IGoalsGrabber getGoalsGrabber(IQueryContext context, ILocationFinder finder) throws Exception {
        IGoalsGrabber def = (IGoalsGrabber)grabbers.get(finder);
        if (def == null) {
            File parentMaven;
            File[] fls;
            GoalsGrabbersAggregator aggregator = new GoalsGrabbersAggregator();
            aggregator.addGoalsGrabber(GoalsGrabbersManager.getDefaultGoalsGrabber(finder));
            File mavenXml = new File(context.getProjectDirectory(), "maven.xml");
            if (mavenXml.exists()) {
                ProjectGoalsGrabber projectGoalsGrabber = new ProjectGoalsGrabber();
                projectGoalsGrabber.setMavenXmlFile(mavenXml.getAbsolutePath());
                aggregator.addGoalsGrabber(projectGoalsGrabber);
            }
            if ((fls = context.getPOMContext().getProjectFiles()) != null && fls.length > 1 && (parentMaven = new File(fls[1].getParentFile(), "maven.xml")).exists()) {
                ProjectGoalsGrabber projectGoalsGrabber = new ProjectGoalsGrabber();
                projectGoalsGrabber.setMavenXmlFile(parentMaven.getAbsolutePath());
                aggregator.addGoalsGrabber(projectGoalsGrabber);
            }
            def = aggregator;
            grabbers.put(finder, def);
        }
        return def;
    }

    public static synchronized IGoalsGrabber getDefaultGoalsGrabber(ILocationFinder finder) throws Exception {
        IGoalsGrabber def = (IGoalsGrabber)defaultGrabbers.get(finder);
        if (def == null) {
            def = new DefaultGoalsGrabber(finder);
            defaultGrabbers.put(finder, def);
        }
        return def;
    }
}

