/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.plugins;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mevenide.plugins.ICustomPluginLoader;
import org.mevenide.plugins.IPluginInfo;
import org.mevenide.plugins.PluginInfoFactory;
import org.mevenide.plugins.PluginProperty;

abstract class AbstractPluginInfo
implements IPluginInfo {
    private static Log logger = LogFactory.getLog((Class)AbstractPluginInfo.class);
    private String artifactId;
    private String version;
    private String name;
    private String longName;
    private String description;
    private Properties props;
    private PluginProperty[] enhanced;

    AbstractPluginInfo() {
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    void setArtifactId(String artifact) {
        this.artifactId = artifact;
    }

    public String getVersion() {
        return this.version;
    }

    void setVersion(String vers) {
        this.version = vers;
    }

    public String getName() {
        return this.name;
    }

    void setName(String nm) {
        this.name = nm;
    }

    public String getDescription() {
        if (this.description == null) {
            this.readProjectValues();
        }
        return this.description;
    }

    public String getLongName() {
        if (this.longName == null) {
            this.readProjectValues();
        }
        return this.longName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getPropertyKeys() {
        if (this.props == null) {
            if (this.enhanced == null) {
                this.getEnhancedPropertyInfo();
            }
            if (this.enhanced.length > 0) {
                HashSet<String> set = new HashSet<String>(this.enhanced.length);
                for (int i = 0; i < this.enhanced.length; ++i) {
                    set.add(this.enhanced[i].getName());
                }
                return set;
            }
            this.props = new Properties();
            InputStream stream = this.getPluginPropsFileInputStream();
            if (stream != null) {
                try {
                    stream = new BufferedInputStream(stream);
                    this.props.load(stream);
                }
                catch (Exception exc) {
                    logger.error((Object)"Cannot read", (Throwable)exc);
                }
                finally {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Exception exc) {
                            logger.error((Object)"Cannot close", (Throwable)exc);
                        }
                    }
                }
            }
        }
        return new HashSet<Object>(this.props.keySet());
    }

    public Set getEnhancedPropertyInfo() {
        if (this.enhanced == null) {
            PluginProperty[] pros = null;
            ICustomPluginLoader loader = PluginInfoFactory.getInstance().getCustomLoader();
            if (loader != null) {
                pros = loader.loadProperties(this.getName(), this.getVersion(), false);
            }
            if (pros == null) {
                pros = new PluginProperty[]{};
            }
            this.enhanced = pros;
        }
        return new HashSet<PluginProperty>(Arrays.asList(this.enhanced));
    }

    protected abstract InputStream getProjectFileInputStream();

    protected abstract InputStream getPluginPropsFileInputStream();

    protected final void readProjectValues() {
        this.readProjectValues(this.getProjectFileInputStream());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void readProjectValues(InputStream projectInputStream) {
        BufferedReader read = null;
        String desc = "";
        String nm = "";
        try {
            read = new BufferedReader(new InputStreamReader(projectInputStream));
            String line = read.readLine();
            int descState = 0;
            int nameState = 0;
            while (line != null && (nameState < 3 || descState < 3)) {
                String lowercase;
                int index;
                int index2;
                if (descState == 0 && (index2 = line.indexOf("<shortDescription>")) > -1) {
                    desc = line.substring(index2 + "<shortDescription>".length()).trim();
                    descState = 1;
                }
                if (descState == 1 || descState == 2) {
                    if (descState == 2) {
                        desc = desc + " " + line.trim();
                    }
                    descState = 2;
                    index2 = desc.indexOf("</shortDescription>");
                    if (index2 > -1) {
                        desc = desc.substring(0, index2);
                        descState = 3;
                    }
                }
                if (nameState == 0 && (index = (lowercase = line.toLowerCase()).indexOf("<name>")) > -1) {
                    nm = line.substring(index + "<name>".length()).trim();
                    nameState = 1;
                }
                if (nameState == 1 || nameState == 2) {
                    if (nameState == 2) {
                        nm = nm + " " + line.trim();
                    }
                    if ((index = nm.indexOf("</name>")) > -1) {
                        nm = nm.substring(0, index);
                        nameState = 3;
                    }
                }
                line = read.readLine();
            }
        }
        catch (Exception exc) {
            logger.error((Object)"Cannot read", (Throwable)exc);
        }
        finally {
            if (read != null) {
                try {
                    read.close();
                }
                catch (IOException exc) {
                    logger.error((Object)"Cannot close", (Throwable)exc);
                }
            }
        }
        this.longName = nm;
        this.description = desc;
        if (this.name == null) {
            this.name = nm;
        }
    }
}

