/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.plugins;

import java.io.File;
import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.Iterator;
import org.mevenide.context.IQueryContext;
import org.mevenide.plugins.ICustomPluginLoader;
import org.mevenide.plugins.PluginInfoManager;
import org.mevenide.plugins.PluginInfoParser;

public final class PluginInfoFactory {
    private static PluginInfoFactory instance;
    private ICustomPluginLoader loader = null;
    private HashSet set = new HashSet();

    private PluginInfoFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PluginInfoFactory getInstance() {
        Class clazz = PluginInfoFactory.class;
        synchronized (clazz) {
            if (instance == null) {
                instance = new PluginInfoFactory();
            }
        }
        return instance;
    }

    public void setCustomLoader(ICustomPluginLoader ldr) {
        this.loader = ldr;
    }

    ICustomPluginLoader getCustomLoader() {
        return this.loader;
    }

    public PluginInfoManager createManager(IQueryContext context) {
        return new PluginInfoManager(context);
    }

    synchronized PluginInfoParser getParser(File cacheDir) {
        Iterator it = this.set.iterator();
        while (it.hasNext()) {
            WeakReference ref = (WeakReference)it.next();
            PluginInfoParser pars = (PluginInfoParser)ref.get();
            if (pars == null) {
                it.remove();
                continue;
            }
            if (!pars.getCachedDir().equals(cacheDir)) continue;
            return pars;
        }
        PluginInfoParser parser = new PluginInfoParser(cacheDir);
        this.set.add(new WeakReference<PluginInfoParser>(parser));
        return parser;
    }
}

