/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.plugins;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.project.Dependency;
import org.mevenide.context.IQueryContext;
import org.mevenide.environment.LocationFinderAggregator;
import org.mevenide.plugins.IPluginInfo;
import org.mevenide.plugins.JarPluginInfo;
import org.mevenide.plugins.PluginInfoFactory;
import org.mevenide.plugins.PluginInfoParser;

public final class PluginInfoManager {
    private IQueryContext context;
    private PluginInfoParser parser;
    private String oldCacheDir = null;
    private LocationFinderAggregator finder;

    PluginInfoManager(IQueryContext queryContext) {
        this.context = queryContext;
        this.finder = new LocationFinderAggregator(this.context);
    }

    private synchronized void findParser() {
        String cacheDir = this.finder.getMavenPluginsDir();
        if (this.oldCacheDir == null || !this.oldCacheDir.equals(cacheDir)) {
            this.oldCacheDir = cacheDir;
            this.parser = PluginInfoFactory.getInstance().getParser(new File(cacheDir));
        }
    }

    public IPluginInfo[] getCurrentPlugins() {
        this.findParser();
        IPluginInfo[] cachedInfos = this.parser.getInfos();
        List projectInfos = this.loadProjectDependentPlugins();
        if (projectInfos.size() > 0) {
            Iterator it = projectInfos.iterator();
            String list = "";
            ArrayList<IPluginInfo> toRet = new ArrayList<IPluginInfo>();
            while (it.hasNext()) {
                IPluginInfo projectInfo = (IPluginInfo)it.next();
                list = list + projectInfo.getArtifactId() + ",";
                toRet.add(projectInfo);
            }
            for (int i = 0; i < cachedInfos.length; ++i) {
                String toMatch = cachedInfos[i].getArtifactId() + ",";
                if (list.indexOf(toMatch) != -1) continue;
                toRet.add(cachedInfos[i]);
            }
            return toRet.toArray(new IPluginInfo[toRet.size()]);
        }
        return cachedInfos;
    }

    private List loadProjectDependentPlugins() {
        ArrayList<JarPluginInfo> prjPlugins = new ArrayList<JarPluginInfo>();
        List deps = this.context.getPOMContext().getFinalProject().getDependencies();
        if (deps != null) {
            Iterator it = deps.iterator();
            while (it.hasNext()) {
                String artId;
                Dependency dep = (Dependency)it.next();
                if (!dep.isPlugin()) continue;
                File repoLocal = new File(this.finder.getMavenLocalRepository());
                String grId = dep.getGroupId() != null ? dep.getGroupId() : dep.getId();
                String string = artId = dep.getArtifactId() != null ? dep.getArtifactId() : dep.getId();
                String relPath = grId + File.separator + "plugins" + File.separator + artId + "-" + dep.getVersion() + ".jar";
                File depLocal = new File(repoLocal, relPath);
                if (!depLocal.exists()) continue;
                JarPluginInfo info = new JarPluginInfo(depLocal);
                info.setArtifactId(artId);
                info.setVersion(dep.getVersion());
                prjPlugins.add(info);
            }
        }
        return prjPlugins;
    }

    public boolean isUsedByProject(IPluginInfo info) {
        HashSet keys = new HashSet();
        keys.addAll(this.context.getUserPropertyKeys());
        int depth = this.context.getPOMContext().getProjectDepth();
        for (int i = 1; i <= depth; ++i) {
            keys.addAll(this.context.getPropertyKeysAt(i * 10 + 1));
            keys.addAll(this.context.getPropertyKeysAt(i * 10 + 0));
        }
        Iterator it = info.getPropertyKeys().iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            if (!keys.contains(key)) continue;
            return true;
        }
        return false;
    }
}

