/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.plugins;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mevenide.plugins.DefaultPluginInfo;
import org.mevenide.plugins.IPluginInfo;

class PluginInfoParser {
    private static Log logger = LogFactory.getLog((Class)PluginInfoParser.class);
    private File cachedDir;
    private File artToPluginFile;
    private long artToPluginFileTimestamp = 0L;
    private Properties artToPluginModel;
    private Set infoList;

    public PluginInfoParser(File cacheDir) {
        this.cachedDir = cacheDir;
        this.artToPluginFile = new File(this.cachedDir, "artifactIdToPlugin.cache");
        this.artToPluginModel = new Properties();
        this.infoList = new TreeSet(new Comp());
    }

    File getCachedDir() {
        return this.cachedDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkReloadModel() {
        if (this.artToPluginFile == null || !this.artToPluginFile.exists()) {
            this.artToPluginModel.clear();
            this.infoList.clear();
            return;
        }
        long lastModified = this.artToPluginFile.lastModified();
        if (lastModified > this.artToPluginFileTimestamp) {
            this.artToPluginModel.clear();
            this.infoList.clear();
            BufferedInputStream stream = null;
            try {
                stream = new BufferedInputStream(new FileInputStream(this.artToPluginFile));
                this.artToPluginModel.load(stream);
                Enumeration<?> en = this.artToPluginModel.propertyNames();
                while (en.hasMoreElements()) {
                    String art = (String)en.nextElement();
                    DefaultPluginInfo info = new DefaultPluginInfo(this.cachedDir);
                    info.setArtifactId(art);
                    info.setName(this.artToPluginModel.getProperty(art));
                    info.setVersion(info.getArtifactId().substring(info.getName().length() + 1));
                    this.infoList.add(info);
                }
            }
            catch (IOException exc) {
                logger.error((Object)"Cannot read file", (Throwable)exc);
            }
            finally {
                this.artToPluginFileTimestamp = lastModified;
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (IOException exc) {
                        logger.error((Object)"Cannot close file", (Throwable)exc);
                    }
                }
            }
        }
    }

    synchronized IPluginInfo[] getInfos() {
        this.checkReloadModel();
        IPluginInfo[] infos = new IPluginInfo[this.infoList.size()];
        return this.infoList.toArray(infos);
    }

    private static class Comp
    implements Comparator {
        private Comp() {
        }

        public int compare(Object obj, Object obj1) {
            IPluginInfo change1 = (IPluginInfo)obj;
            IPluginInfo change2 = (IPluginInfo)obj1;
            return change1.getName().compareTo(change2.getName());
        }
    }
}

