/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.reports;

import java.io.File;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.mevenide.context.IQueryContext;

public final class CheckstyleResult {
    private static final Log logger = LogFactory.getLog((Class)CheckstyleResult.class);
    private IQueryContext context;
    private boolean loaded;
    private Object LOCK = new Object();
    private Map violations;

    public CheckstyleResult(IQueryContext con) {
        this.context = con;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File[] getFiles() {
        Object object = this.LOCK;
        synchronized (object) {
            if (!this.loaded) {
                this.loadReport();
            }
        }
        File[] files = new File[this.violations.size()];
        files = this.violations.keySet().toArray(files);
        return files;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getViolationsForFile(File file) {
        Object object = this.LOCK;
        synchronized (object) {
            if (!this.loaded) {
                this.loadReport();
                this.loaded = true;
            }
        }
        return (List)this.violations.get(file);
    }

    private void loadReport() {
        File reportFile = new File(this.context.getResolver().getResolvedValue("maven.build.dir"), "checkstyle-raw-report.xml");
        this.violations = new TreeMap(new FileComparator());
        if (reportFile.exists()) {
            try {
                SAXBuilder builder = new SAXBuilder();
                Document document = builder.build(reportFile);
                List files = document.getRootElement().getChildren("file");
                if (files != null && files.size() > 0) {
                    Iterator it = files.iterator();
                    while (it.hasNext()) {
                        Element el = (Element)it.next();
                        String name = el.getAttributeValue("name");
                        if (name == null) continue;
                        ArrayList<Violation> viols = new ArrayList<Violation>();
                        File file = new File(name);
                        List vs = el.getChildren("error");
                        if (vs == null) continue;
                        Iterator vsIter = vs.iterator();
                        while (vsIter.hasNext()) {
                            Element vsElem = (Element)vsIter.next();
                            Violation v = new Violation();
                            v.setFile(file);
                            v.setLine(vsElem.getAttributeValue("line"));
                            v.setColumn(vsElem.getAttributeValue("column"));
                            v.setSeverity(vsElem.getAttributeValue("severity"));
                            v.setSource(vsElem.getAttributeValue("source"));
                            v.setMessage(vsElem.getAttributeValue("message"));
                            viols.add(v);
                        }
                        if (viols.size() <= 0) continue;
                        this.violations.put(file, viols);
                    }
                }
            }
            catch (Exception exc) {
                logger.error((Object)"exception when loading report=", (Throwable)exc);
            }
        }
    }

    private static class FileComparator
    implements Comparator {
        private FileComparator() {
        }

        public int compare(Object o1, Object o2) {
            File file1 = (File)o1;
            File file2 = (File)o2;
            return file1.getAbsolutePath().compareTo(file2.getAbsolutePath());
        }
    }

    public static class Violation {
        private String line;
        private String column;
        private File file;
        private String message;
        private String severity;
        private String source;

        Violation() {
        }

        public String getLine() {
            return this.line;
        }

        void setLine(String line) {
            this.line = line;
        }

        public File getFile() {
            return this.file;
        }

        void setFile(File file) {
            this.file = file;
        }

        public String getColumn() {
            return this.column;
        }

        void setColumn(String column) {
            this.column = column;
        }

        public String getMessage() {
            return this.message;
        }

        void setMessage(String message) {
            this.message = message;
        }

        public String getSeverity() {
            return this.severity;
        }

        void setSeverity(String severity) {
            this.severity = severity;
        }

        public String getSource() {
            return this.source;
        }

        void setSource(String source) {
            this.source = source;
        }
    }
}

