/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.reports;

import java.io.File;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.mevenide.context.IQueryContext;

public final class FindbugsResult {
    private static final Log logger = LogFactory.getLog((Class)FindbugsResult.class);
    private IQueryContext context;
    private boolean loaded;
    private Object LOCK = new Object();
    private Map violations;

    public FindbugsResult(IQueryContext con) {
        this.context = con;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getClassNames() {
        Object object = this.LOCK;
        synchronized (object) {
            if (!this.loaded) {
                this.loadReport();
            }
        }
        String[] files = new String[this.violations.size()];
        files = this.violations.keySet().toArray(files);
        return files;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getViolationsForClass(String className) {
        Object object = this.LOCK;
        synchronized (object) {
            if (!this.loaded) {
                this.loadReport();
                this.loaded = true;
            }
        }
        return (List)this.violations.get(className);
    }

    private void loadReport() {
        File reportFile = new File(this.context.getResolver().getResolvedValue("maven.build.dir"), "findbugs-raw-report.xml");
        this.violations = new TreeMap(new StringComparator());
        if (reportFile.exists()) {
            try {
                SAXBuilder builder = new SAXBuilder();
                Document document = builder.build(reportFile);
                List files = document.getRootElement().getChildren("file");
                if (files != null && files.size() > 0) {
                    Iterator it = files.iterator();
                    while (it.hasNext()) {
                        Element el = (Element)it.next();
                        String name = el.getAttributeValue("classname");
                        if (name == null) continue;
                        ArrayList<Violation> viols = new ArrayList<Violation>();
                        List vs = el.getChildren("BugInstance");
                        if (vs == null) continue;
                        Iterator vsIter = vs.iterator();
                        while (vsIter.hasNext()) {
                            Element vsElem = (Element)vsIter.next();
                            Violation v = new Violation();
                            v.setClassName(name);
                            v.setLine(vsElem.getAttributeValue("line"));
                            v.setPriority(vsElem.getAttributeValue("priority"));
                            v.setType(vsElem.getAttributeValue("type"));
                            v.setMessage(vsElem.getAttributeValue("message"));
                            viols.add(v);
                        }
                        if (viols.size() <= 0) continue;
                        this.violations.put(name, viols);
                    }
                }
            }
            catch (Exception exc) {
                logger.error((Object)"exception when loading report=", (Throwable)exc);
            }
        }
    }

    private static class StringComparator
    implements Comparator {
        private StringComparator() {
        }

        public int compare(Object o1, Object o2) {
            String file1 = (String)o1;
            String file2 = (String)o2;
            return file1.compareTo(file2);
        }
    }

    public static class Violation {
        private String line;
        private String className;
        private String message;
        private String priority;
        private String type;

        Violation() {
        }

        public String getLine() {
            return this.line;
        }

        void setLine(String line) {
            this.line = line;
        }

        public String getClassName() {
            return this.className;
        }

        void setClassName(String className) {
            this.className = className;
        }

        public String getMessage() {
            return this.message;
        }

        void setMessage(String message) {
            this.message = message;
        }

        public String getPriority() {
            return this.priority;
        }

        void setPriority(String priority) {
            this.priority = priority;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }
    }
}

