/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.reports;

import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.mevenide.environment.ConfigUtils;
import org.mevenide.environment.ILocationFinder;
import org.mevenide.reports.IReportsFinder;

public class JDomReportsFinder
implements IReportsFinder {
    private static final Log log = LogFactory.getLog((Class)JDomReportsFinder.class);
    private ILocationFinder finder;
    private File pluginsDir;

    public JDomReportsFinder() {
        this(ConfigUtils.getDefaultLocationFinder());
    }

    public JDomReportsFinder(ILocationFinder find) {
        this.finder = find;
    }

    public String[] findReports() throws Exception {
        this.pluginsDir = new File(this.finder.getMavenPluginsDir());
        File pluginsCache = new File(this.pluginsDir, "plugins.cache");
        Properties properties = new Properties();
        properties.load(new FileInputStream(pluginsCache));
        Enumeration<Object> elements = properties.keys();
        HashMap<String, Object> pluginCandidates = new HashMap<String, Object>();
        while (elements.hasMoreElements()) {
            String key = (String)elements.nextElement();
            if (key.indexOf(":register") <= -1) continue;
            pluginCandidates.put(key, properties.get(key));
        }
        List verifiedCandidates = this.verifyAndSort(pluginCandidates);
        return verifiedCandidates.toArray(new String[0]);
    }

    private List verifyAndSort(Map pluginCandidates) throws Exception {
        ArrayList<String> verified = new ArrayList<String>();
        Iterator it = pluginCandidates.keySet().iterator();
        while (it.hasNext()) {
            String pluginHome;
            String registarGoal = (String)it.next();
            if (!this.isRegistar(registarGoal, pluginHome = (String)pluginCandidates.get(registarGoal))) continue;
            verified.add(registarGoal.substring(0, registarGoal.indexOf(":register")));
        }
        return verified;
    }

    private boolean isRegistar(String registarGoal, String pluginHome) throws Exception {
        Document document;
        File jellyFile = new File(new File(this.pluginsDir, pluginHome), "plugin.jelly");
        SAXBuilder builder = new SAXBuilder();
        try {
            document = builder.build(jellyFile);
        }
        catch (JDOMException e) {
            String message = "Unable to build Document";
            log.error((Object)message, (Throwable)e);
            return false;
        }
        return this.checkDocument(registarGoal, pluginHome, document);
    }

    private boolean checkDocument(String registarGoal, String pluginHome, Document document) throws Exception {
        List goals = document.getRootElement().getChildren("goal");
        if (goals != null) {
            for (int i = 0; i < goals.size(); ++i) {
                Element goal = (Element)goals.get(i);
                if (!goal.getAttributeValue("name").equals(registarGoal)) continue;
                return this.visit(goal, pluginHome, document);
            }
        }
        return false;
    }

    boolean visit(Element goal, String pluginHome, Document document) throws Exception {
        StringTokenizer tokenizer;
        List children = goal.getChildren();
        for (int i = 0; i < children.size(); ++i) {
            Element e = (Element)children.get(i);
            if (e.getName().equals("registerReport") && e.getNamespace().getURI().equals("doc")) {
                return true;
            }
            if (e.getName().equals("attainGoal")) {
                return this.isRegistar(e.getAttributeValue("name"), pluginHome);
            }
            boolean found = this.visit(e, pluginHome, document);
            if (!found) continue;
            return found;
        }
        String prereqs = goal.getAttributeValue("prereqs");
        if (prereqs != null && (tokenizer = new StringTokenizer(prereqs, ",")).hasMoreTokens()) {
            String prereq = tokenizer.nextToken();
            return this.checkDocument(prereq, pluginHome, document);
        }
        return false;
    }
}

