/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.reports;

import java.io.File;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.mevenide.context.IQueryContext;

public final class PmdResult {
    private static final Log logger = LogFactory.getLog((Class)PmdResult.class);
    private IQueryContext context;
    private boolean loaded;
    private Object LOCK = new Object();
    private TreeMap violations;

    public PmdResult(IQueryContext con) {
        this.context = con;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File[] getFiles() {
        Object object = this.LOCK;
        synchronized (object) {
            if (!this.loaded) {
                this.loadReport();
            }
        }
        File[] files = new File[this.violations.size()];
        files = this.violations.keySet().toArray(files);
        return files;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getViolationsForFile(File file) {
        Object object = this.LOCK;
        synchronized (object) {
            if (!this.loaded) {
                this.loadReport();
                this.loaded = true;
            }
        }
        return (List)this.violations.get(file);
    }

    private void loadReport() {
        File reportFile = new File(this.context.getResolver().getResolvedValue("maven.build.dir"), "pmd-raw-report.xml");
        this.violations = new TreeMap(new FileComparator());
        if (reportFile.exists()) {
            try {
                SAXBuilder builder = new SAXBuilder();
                Document document = builder.build(reportFile);
                List files = document.getRootElement().getChildren("file");
                if (files != null && files.size() > 0) {
                    Iterator it = files.iterator();
                    while (it.hasNext()) {
                        Element el = (Element)it.next();
                        String name = el.getAttributeValue("name");
                        if (name == null) continue;
                        ArrayList<Violation> viols = new ArrayList<Violation>();
                        File file = new File(name);
                        this.violations.put(file, viols);
                        List vs = el.getChildren("violation");
                        if (vs == null) continue;
                        Iterator vsIter = vs.iterator();
                        while (vsIter.hasNext()) {
                            Element vsElem = (Element)vsIter.next();
                            Violation v = new Violation();
                            v.setFile(file);
                            v.setLine(vsElem.getAttributeValue("line"));
                            v.setViolationId(vsElem.getAttributeValue("rule"));
                            v.setViolationText(vsElem.getText());
                            viols.add(v);
                        }
                    }
                }
            }
            catch (Exception exc) {
                logger.error((Object)"exception when loading report=", (Throwable)exc);
            }
        }
    }

    private static class FileComparator
    implements Comparator {
        private FileComparator() {
        }

        public int compare(Object o1, Object o2) {
            File file1 = (File)o1;
            File file2 = (File)o2;
            return file1.getAbsolutePath().compareTo(file2.getAbsolutePath());
        }
    }

    public static class Violation {
        private String line;
        private String violationId;
        private File file;
        private String violationText;

        Violation() {
        }

        public String getLine() {
            return this.line;
        }

        void setLine(String line) {
            this.line = line;
        }

        public String getViolationId() {
            return this.violationId;
        }

        void setViolationId(String viloationId) {
            this.violationId = viloationId;
        }

        public File getFile() {
            return this.file;
        }

        void setFile(File file) {
            this.file = file;
        }

        public String getViolationText() {
            return this.violationText;
        }

        void setViolationText(String violationText) {
            this.violationText = violationText;
        }
    }
}

