/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.netbeans.grammar;

import java.io.File;
import java.io.FilenameFilter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mevenide.environment.SysEnvLocationFinder;
import org.mevenide.environment.sysenv.SysEnvProvider;
import org.mevenide.netbeans.grammar.NbSysEnvProvider;
import org.openide.modules.ModuleInstall;

public class MavenGrammarModule
extends ModuleInstall {
    private static Log log = LogFactory.getLog((Class)MavenGrammarModule.class);
    private static final long serialVersionUID = -485754848837354747L;
    private static transient ClassLoader mavenClassLoader;

    public void restored() {
        SysEnvLocationFinder.setDefaultSysEnvProvider((SysEnvProvider)new NbSysEnvProvider());
    }

    public void validate() throws IllegalStateException {
        String maven_home = System.getProperty("Env-MAVEN_HOME");
        if (maven_home == null) {
            throw new IllegalStateException("Maven not installed or the MAVEN_HOME property not set. Cannot Install.");
        }
        File pluginDir = new File(maven_home, "lib");
        File[] jars = pluginDir.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.startsWith("commons-jelly") || name.equals("maven.jar");
            }
        });
        try {
            URL[] urls = new URL[jars.length];
            for (int i = 0; i < jars.length; ++i) {
                urls[i] = jars[i].toURL();
            }
            mavenClassLoader = new URLClassLoader(urls);
        }
        catch (MalformedURLException exc) {
            System.out.println("error" + exc);
        }
    }

    public static ClassLoader getMavenClassLoader() {
        return mavenClassLoader;
    }
}

