/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.netbeans.grammar;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mevenide.grammar.AttrCompletionProvider;
import org.mevenide.grammar.AttributeCompletion;
import org.mevenide.grammar.GrammarUtilities;
import org.mevenide.grammar.TagLib;
import org.mevenide.grammar.TagLibManager;
import org.mevenide.grammar.TagLibProvider;
import org.mevenide.netbeans.grammar.NbTagLibProvider;
import org.netbeans.modules.xml.api.model.GrammarQuery;
import org.netbeans.modules.xml.api.model.GrammarResult;
import org.netbeans.modules.xml.api.model.HintContext;
import org.netbeans.modules.xml.spi.dom.AbstractNode;
import org.openide.nodes.Node;
import org.openide.util.Utilities;
import org.openide.util.enum.EmptyEnumeration;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class MavenJellyGrammar
implements GrammarQuery {
    private static Log logger = LogFactory.getLog((Class)MavenJellyGrammar.class);
    private static TagLibManager manager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static TagLibManager getManager() {
        if (manager == null) {
            Class clazz = MavenJellyGrammar.class;
            synchronized (clazz) {
                if (manager == null) {
                    manager = new TagLibManager();
                    NbTagLibProvider prov = new NbTagLibProvider();
                    manager.setProvider((TagLibProvider)prov);
                    manager.setAttrCompletionProvider((AttrCompletionProvider)prov);
                }
            }
        }
        return manager;
    }

    private TagLib getDefaultTagLib() {
        return MavenJellyGrammar.getManager().getTagLibrary("default-maven");
    }

    private Node findRootNode(Node virtualElementCtx) {
        Node current;
        for (current = virtualElementCtx; !(current == null || current.getNodeName() != null && current.getNodeName().equals("project")); current = current.getParentNode()) {
            logger.debug((Object)("findRootNode:curr rootNode is=" + current.getNodeName()));
        }
        return current;
    }

    private Map getNameSpaceMappings(Node projectNode) {
        HashMap<String, String> toReturn = new HashMap<String, String>();
        NamedNodeMap map = projectNode.getAttributes();
        if (map != null) {
            for (int i = 0; i < map.getLength(); ++i) {
                Node attrNode = map.item(i);
                String attrName = attrNode.getNodeName();
                if (!attrName.startsWith("xmlns:")) continue;
                toReturn.put(attrName.substring("xmlns:".length()), attrNode.getNodeValue());
                logger.debug((Object)("namespace name=" + attrName.substring("xmlns:".length()) + " value=" + attrNode.getNodeValue()));
            }
        }
        return toReturn;
    }

    public Component getCustomizer(HintContext nodeCtx) {
        return null;
    }

    public Node.Property[] getProperties(HintContext nodeCtx) {
        return new Node.Property[0];
    }

    public boolean hasCustomizer(HintContext nodeCtx) {
        return false;
    }

    public boolean isAllowed(Enumeration en) {
        return true;
    }

    public Enumeration queryAttributes(HintContext ownerElementCtx) {
        String start = ownerElementCtx.getCurrentPrefix();
        logger.debug((Object)("start=" + start));
        TreeSet<Attribute> toReturn = new TreeSet<Attribute>(new SimpleComparator());
        String elName = ownerElementCtx.getNodeName();
        int separ = elName.indexOf(58);
        TagLib lib = null;
        String tag = elName;
        if (separ > 0) {
            String ns = elName.substring(0, separ);
            tag = separ == elName.length() ? "" : elName.substring(separ + 1);
            lib = this.findTagLib(ns, (Node)ownerElementCtx);
        } else {
            lib = this.getDefaultTagLib();
        }
        if (lib != null) {
            Iterator it = lib.getTagAttrs(tag).iterator();
            while (it.hasNext()) {
                String attr = (String)it.next();
                if (!attr.startsWith(start)) continue;
                toReturn.add(new Attribute(attr));
            }
        }
        return Collections.enumeration(toReturn);
    }

    public GrammarResult queryDefault(HintContext parentNodeCtx) {
        logger.debug((Object)"query default");
        return null;
    }

    private TagLib findTagLib(String ns, Node context) {
        Map mapping;
        String jellyTag;
        Node rootNode = this.findRootNode(context);
        if (rootNode != null && (jellyTag = (String)(mapping = this.getNameSpaceMappings(rootNode)).get(ns)) != null) {
            return MavenJellyGrammar.getManager().getTagLibrary(jellyTag);
        }
        return null;
    }

    private Node findParentInSameNamespace(String ns, Node el) {
        for (Node parent = el.getParentNode(); parent != null; parent = parent.getParentNode()) {
            String name = parent.getNodeName();
            if (name == null) continue;
            int separ = name.indexOf(58);
            if (separ > 0) {
                String nameSpace = name.substring(0, separ);
                logger.debug((Object)("findParentInSameNamespace-" + nameSpace));
                if (!nameSpace.equals(ns)) continue;
                return parent;
            }
            if (ns != null) continue;
            return parent;
        }
        return null;
    }

    private Map findTagLibs(String nsStart, HintContext context) {
        Node rootNode = this.findRootNode((Node)context);
        HashMap<String, TagLib> toReturn = new HashMap<String, TagLib>(10);
        if (rootNode != null) {
            Map mapping = this.getNameSpaceMappings(rootNode);
            Iterator it = mapping.keySet().iterator();
            while (it.hasNext()) {
                String jellyTag;
                String ns = (String)it.next();
                if (nsStart != null && nsStart.length() != 0 && !ns.startsWith(nsStart) || (jellyTag = (String)mapping.get(ns)) == null) continue;
                toReturn.put(ns, MavenJellyGrammar.getManager().getTagLibrary(jellyTag));
            }
        }
        return toReturn;
    }

    public Enumeration queryElements(HintContext virtualElementCtx) {
        String start = virtualElementCtx.getCurrentPrefix();
        logger.debug((Object)("start=" + start));
        TreeSet<TagLibElement> toReturn = new TreeSet<TagLibElement>(new ElementComparator());
        int separ = start.indexOf(58);
        if (separ > 0) {
            String ns = start.substring(0, separ);
            String tag = separ == start.length() ? "" : start.substring(separ + 1);
            logger.debug((Object)("namespace is " + ns));
            TagLib lib = this.findTagLib(ns, (Node)virtualElementCtx);
            this.createSubTagsElements(ns, (Node)virtualElementCtx, toReturn, lib, tag);
            this.createTagElements(lib.getRootTags(), toReturn, ns, tag);
        } else {
            logger.debug((Object)"no namespace yet");
            Map libs = this.findTagLibs(start, virtualElementCtx);
            ArrayList singleTags = new ArrayList();
            if (libs.size() > 0) {
                TreeSet sortedLibs = new TreeSet(libs.keySet());
                Iterator it = sortedLibs.iterator();
                while (it.hasNext()) {
                    String ns = (String)it.next();
                    TagLib lb = (TagLib)libs.get(ns);
                    logger.debug((Object)("adding namespace=" + ns));
                    toReturn.add(new TagLibElement(ns));
                    logger.debug((Object)("adding lib=" + lb));
                    this.createTagElements(lb.getRootTags(), singleTags, ns, null);
                    this.createSubTagsElements(ns, (Node)virtualElementCtx, singleTags, lb, null);
                }
            }
            this.createTagElements(this.getDefaultTagLib().getRootTags(), toReturn, null, start);
            this.createSubTagsElements(null, (Node)virtualElementCtx, toReturn, this.getDefaultTagLib(), start);
            toReturn.addAll(singleTags);
        }
        return Collections.enumeration(toReturn);
    }

    private void createTagElements(Collection col, Collection elemList, String namespace, String start) {
        Iterator it = col.iterator();
        while (it.hasNext()) {
            String name = (String)it.next();
            if (start != null && !name.startsWith(start)) continue;
            elemList.add(new MyElement(namespace, name));
        }
    }

    private void createSubTagsElements(String ns, Node virtualElementCtx, Collection ccList, TagLib lib, String start) {
        Node parent = this.findParentInSameNamespace(ns, virtualElementCtx);
        if (parent != null) {
            String parentTag = parent.getNodeName();
            int separ = parentTag.indexOf(58);
            if (separ > -1) {
                parentTag = parentTag.substring(separ + 1);
            }
            logger.debug((Object)("parenttag=" + parentTag));
            Collection col = lib.getSubTags(parentTag);
            if (col != null) {
                this.createTagElements(col, ccList, ns, start);
            }
        }
    }

    public Enumeration queryEntities(String prefix) {
        logger.debug((Object)"query entities");
        return EmptyEnumeration.EMPTY;
    }

    public Enumeration queryNotations(String prefix) {
        logger.debug((Object)"query notation");
        return EmptyEnumeration.EMPTY;
    }

    public Enumeration queryValues(HintContext virtualTextCtx) {
        TreeSet<TextNode> toReturn;
        block5: {
            String start;
            HintContext parent;
            block6: {
                parent = virtualTextCtx;
                start = virtualTextCtx.getCurrentPrefix();
                toReturn = new TreeSet<TextNode>(new SimpleComparator());
                if (parent == null || parent.getNodeType() != 2) break block5;
                if (!parent.getNodeName().startsWith("xmlns:")) break block6;
                String[] libs = MavenJellyGrammar.getManager().getAvailableTagLibs();
                for (int i = 0; i < libs.length; ++i) {
                    logger.debug((Object)("lib=" + libs[i]));
                    if (!libs[i].startsWith(start)) continue;
                    toReturn.add(new TextNode(libs[i]));
                }
                break block5;
            }
            Attr attrParent = (Attr)parent;
            Element elementParent = attrParent.getOwnerElement();
            int nsint = elementParent.getNodeName().indexOf(":");
            String namespace = nsint > -1 ? elementParent.getNodeName().substring(0, nsint) : null;
            String tagName = nsint > -1 && nsint < elementParent.getNodeName().length() - 1 ? elementParent.getNodeName().substring(nsint + 1) : elementParent.getNodeName();
            TagLib lib = namespace == null ? this.getDefaultTagLib() : this.findTagLib(namespace, elementParent);
            String lastWord = GrammarUtilities.extractLastWord((String)start);
            String initialPart = start.substring(0, start.length() - lastWord.length());
            if (lib != null) {
                logger.debug((Object)("found taglib" + lib.getName()));
                Collection types = lib.getAttrCompletionTypes(tagName, virtualTextCtx.getNodeName());
                Iterator it = types.iterator();
                while (it.hasNext()) {
                    String type = (String)it.next();
                    logger.debug((Object)("attr compl type=" + type));
                    AttributeCompletion compl = MavenJellyGrammar.getManager().getAttributeCompletion(type);
                    Collection col = compl.getValueHints(lastWord);
                    Iterator valIt = col.iterator();
                    while (valIt.hasNext()) {
                        toReturn.add(new TextNode((String)valIt.next(), initialPart));
                    }
                }
            }
            if (!lastWord.startsWith("maven.")) break block5;
            AttributeCompletion compl = MavenJellyGrammar.getManager().getAttributeCompletion("pluginDefaults");
            Collection col = compl.getValueHints(lastWord);
            Iterator valIt = col.iterator();
            while (valIt.hasNext()) {
                toReturn.add(new TextNode((String)valIt.next(), initialPart));
            }
        }
        return Collections.enumeration(toReturn);
    }

    private static class ElementComparator
    implements Comparator {
        private ElementComparator() {
        }

        public int compare(Object o1, Object o2) {
            AbstractResultNode nd1 = (AbstractResultNode)((Object)o1);
            AbstractResultNode nd2 = (AbstractResultNode)((Object)o2);
            if (nd1 instanceof TagLibElement && !(nd2 instanceof TagLibElement)) {
                return -1;
            }
            if (!(nd1 instanceof TagLibElement) && nd2 instanceof TagLibElement) {
                return 1;
            }
            String name1 = nd1.getNodeName();
            String name2 = nd2.getNodeName();
            int index1 = name1.indexOf(58);
            int index2 = name2.indexOf(58);
            if (index1 >= 0 && index2 < 0) {
                return 1;
            }
            if (index2 >= 0 && index1 < 0) {
                return -1;
            }
            return name1.compareTo(name2);
        }
    }

    private static class SimpleComparator
    implements Comparator {
        private SimpleComparator() {
        }

        public int compare(Object o1, Object o2) {
            AbstractResultNode nd1 = (AbstractResultNode)((Object)o1);
            AbstractResultNode nd2 = (AbstractResultNode)((Object)o2);
            return nd1.getTagName().compareTo(nd2.getTagName());
        }
    }

    private static class TextNode
    extends AbstractResultNode
    implements Text {
        private String name;
        private String start = "";

        TextNode(String name) {
            this.name = name;
        }

        TextNode(String name, String start) {
            this(name);
            this.start = start;
        }

        public short getNodeType() {
            return 3;
        }

        public String getNodeName() {
            return this.name;
        }

        public String getNodeValue() {
            return this.start + this.name;
        }

        public String getTagName() {
            return this.name;
        }
    }

    private static class Attribute
    extends AbstractResultNode
    implements Attr {
        private String name;

        Attribute(String name) {
            this.name = name;
        }

        public short getNodeType() {
            return 2;
        }

        public String getNodeName() {
            return this.name;
        }

        public String getTagName() {
            return this.name;
        }
    }

    private static class TagLibElement
    extends AbstractResultNode
    implements Element {
        private String namespace;

        TagLibElement(String ns) {
            this.namespace = ns;
        }

        public short getNodeType() {
            return 1;
        }

        public String getNodeName() {
            return this.namespace + ":";
        }

        public String getTagName() {
            return this.namespace;
        }

        public Icon getIcon(int kind) {
            return new ImageIcon(Utilities.loadImage((String)"org/mevenide/netbeans/grammar/resources/NamespaceIcon.gif", (boolean)true));
        }

        public boolean isEmptyElement() {
            return false;
        }
    }

    private static class MyElement
    extends AbstractResultNode
    implements Element {
        private String name;
        private String namespace;

        MyElement(String ns, String name) {
            this.name = name;
            this.namespace = ns;
        }

        public short getNodeType() {
            return 1;
        }

        public String getNodeName() {
            return this.namespace == null ? this.name : this.namespace + ":" + this.name;
        }

        public String getTagName() {
            return this.name;
        }
    }

    private static abstract class AbstractResultNode
    extends AbstractNode
    implements GrammarResult {
        private AbstractResultNode() {
        }

        public Icon getIcon(int kind) {
            return null;
        }

        public String getDescription() {
            return this.getNodeName() + " desc";
        }

        public String getText() {
            return this.getNodeName();
        }

        public String getDisplayName() {
            return this.getNodeName();
        }

        public boolean isEmptyElement() {
            return false;
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof AbstractResultNode)) {
                return false;
            }
            AbstractResultNode res = (AbstractResultNode)((Object)obj);
            int index1 = this.getNodeName().indexOf(58);
            int index2 = res.getNodeName().indexOf(58);
            if (index1 >= 0 && index2 < 0 || index2 >= 0 && index1 < 0) {
                return false;
            }
            return this.getNodeName().equals(res.getNodeName());
        }
    }
}

