/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.netbeans.grammar;

import java.awt.Component;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.Icon;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.filter.ElementFilter;
import org.jdom.filter.Filter;
import org.jdom.input.SAXBuilder;
import org.netbeans.modules.xml.api.model.GrammarQuery;
import org.netbeans.modules.xml.api.model.GrammarResult;
import org.netbeans.modules.xml.api.model.HintContext;
import org.netbeans.modules.xml.spi.dom.AbstractNode;
import org.openide.nodes.Node;
import org.openide.util.enum.EmptyEnumeration;
import org.w3c.dom.Node;

public class MavenProjectGrammar
implements GrammarQuery {
    private static Log logger = LogFactory.getLog((Class)MavenProjectGrammar.class);
    private Document schemaDoc3;
    private Document schemaDoc4;

    public MavenProjectGrammar() {
        try {
            SAXBuilder builder = new SAXBuilder();
            InputStream stream = this.getClass().getResourceAsStream("/org/mevenide/netbeans/grammar/resources/maven-project-3.xsd");
            logger.debug((Object)("stream is not null=" + (stream != null)));
            this.schemaDoc3 = builder.build(stream);
            stream = this.getClass().getResourceAsStream("/org/mevenide/netbeans/grammar/resources/maven-project-4.xsd");
            this.schemaDoc4 = builder.build(stream);
        }
        catch (Exception exc) {
            logger.error((Object)"cannot read schema for maven project", (Throwable)exc);
        }
    }

    public Component getCustomizer(HintContext nodeCtx) {
        return null;
    }

    public Node.Property[] getProperties(HintContext nodeCtx) {
        return new Node.Property[0];
    }

    public boolean hasCustomizer(HintContext nodeCtx) {
        return false;
    }

    public boolean isAllowed(Enumeration en) {
        return true;
    }

    public Enumeration queryAttributes(HintContext ownerElementCtx) {
        return EmptyEnumeration.EMPTY;
    }

    public GrammarResult queryDefault(HintContext parentNodeCtx) {
        return null;
    }

    public Enumeration queryElements(HintContext virtualElementCtx) {
        String start = virtualElementCtx.getCurrentPrefix();
        logger.debug((Object)("start=" + start));
        Document schemaDoc = this.findPomVersion(virtualElementCtx) == 4 ? this.schemaDoc4 : this.schemaDoc3;
        Node parentNode = virtualElementCtx.getParentNode();
        if (parentNode != null && schemaDoc != null) {
            String parentName = parentNode.getNodeName();
            logger.debug((Object)("parent name=" + parentName));
            Element schemaRoot = schemaDoc.getRootElement();
            List content = schemaRoot.getContent((Filter)new RootDefinitionElementFilter(parentName));
            logger.debug((Object)("returned items=" + content.size()));
            Vector toReturn = new Vector();
            Iterator it = content.iterator();
            while (it.hasNext()) {
                Element parentEl = (Element)it.next();
                Element seq = this.findSequenceElement(parentEl);
                if (seq != null) {
                    this.processSequence(start, seq, toReturn, schemaRoot);
                    continue;
                }
                logger.warn((Object)"no complexType/sequence subelements defined in the found element");
            }
            return toReturn.elements();
        }
        return EmptyEnumeration.EMPTY;
    }

    private Element findSequenceElement(Element parent) {
        logger.debug((Object)("findSequence parent name=" + parent.getAttributeValue("name")));
        logger.debug((Object)("findSequence parent content size=" + parent.getChildren().size()));
        Element complex = parent.getChild("complexType", parent.getNamespace());
        logger.debug((Object)("findSequence complex found" + (complex != null)));
        if (complex != null) {
            return complex.getChild("sequence", parent.getNamespace());
        }
        return null;
    }

    private void processElement(String matches, Element childEl, Vector suggestions, Element rootSchemaElement) {
        if (childEl.getName().equals("element")) {
            String childRefAttr = childEl.getAttributeValue("ref");
            logger.debug((Object)("child ref attr=" + childRefAttr));
            if (childRefAttr == null) {
                childRefAttr = childEl.getAttributeValue("name");
            }
            if (childRefAttr != null && childRefAttr.startsWith(matches)) {
                suggestions.add(new MyElement(childRefAttr));
            }
        } else if (childEl.getName().equals("group")) {
            String grName = childEl.getAttributeValue("ref");
            if (grName != null) {
                List groupList = rootSchemaElement.getChildren("group", rootSchemaElement.getNamespace());
                Iterator it = groupList.iterator();
                boolean found = false;
                while (it.hasNext()) {
                    Element grEl = (Element)it.next();
                    String grId = grEl.getAttributeValue("name");
                    if (grId == null || !grId.equals(grName)) continue;
                    this.processGroup(matches, grEl, suggestions, rootSchemaElement);
                    found = true;
                    break;
                }
                if (!found) {
                    logger.warn((Object)("No schema group matches " + grName));
                }
            } else {
                logger.warn((Object)"No schema group reference");
            }
        }
    }

    private void processGroup(String matches, Element groupEl, Vector suggestions, Element rootSchemaElement) {
        Element seq = groupEl.getChild("sequence", groupEl.getNamespace());
        if (seq != null) {
            this.processSequence(matches, seq, suggestions, rootSchemaElement);
        }
    }

    private void processSequence(String matches, Element seqEl, Vector suggestions, Element rootSchemaElement) {
        List availables = seqEl.getContent((Filter)new DefinitionContentElementFilter());
        logger.debug((Object)("content size=" + availables.size()));
        Iterator availIt = availables.iterator();
        while (availIt.hasNext()) {
            Element childEl = (Element)availIt.next();
            this.processElement(matches, childEl, suggestions, rootSchemaElement);
        }
    }

    public Enumeration queryEntities(String prefix) {
        return EmptyEnumeration.EMPTY;
    }

    public Enumeration queryNotations(String prefix) {
        return EmptyEnumeration.EMPTY;
    }

    public Enumeration queryValues(HintContext virtualTextCtx) {
        return EmptyEnumeration.EMPTY;
    }

    private int findPomVersion(HintContext virtualElementCtx) {
        Object rootNode = null;
        int toReturn = 3;
        return toReturn;
    }

    private class DefinitionContentElementFilter
    extends ElementFilter {
        public boolean matches(Object obj) {
            boolean toReturn = super.matches(obj);
            if (toReturn) {
                Element el = (Element)obj;
                toReturn = false;
                if ("element".equals(el.getName()) || "group".equals(el.getName())) {
                    toReturn = true;
                }
            }
            return toReturn;
        }
    }

    private class RootDefinitionElementFilter
    extends ElementFilter {
        private String text;

        public RootDefinitionElementFilter(String name) {
            this.text = name;
        }

        public boolean matches(Object obj) {
            boolean toReturn = super.matches(obj);
            if (toReturn) {
                String elName;
                Element el = (Element)obj;
                toReturn = false;
                if ("element".equals(el.getName()) && (elName = el.getAttributeValue("name")) != null && this.text.equals(elName)) {
                    toReturn = true;
                }
            }
            return toReturn;
        }
    }

    private static class MyElement
    extends AbstractResultNode
    implements org.w3c.dom.Element {
        private String name;

        MyElement(String name) {
            this.name = name;
        }

        public short getNodeType() {
            return 1;
        }

        public String getNodeName() {
            return this.name;
        }

        public String getTagName() {
            return this.name;
        }
    }

    private static abstract class AbstractResultNode
    extends AbstractNode
    implements GrammarResult {
        private AbstractResultNode() {
        }

        public Icon getIcon(int kind) {
            return null;
        }

        public String getDescription() {
            return this.getNodeName() + " desc";
        }

        public String getText() {
            return this.getNodeName();
        }

        public String getDisplayName() {
            return this.getNodeName() + " disp";
        }

        public boolean isEmptyElement() {
            return false;
        }
    }
}

