/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.netbeans.grammar;

import java.io.File;
import java.util.HashSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mevenide.environment.ConfigUtils;
import org.mevenide.grammar.AttrCompletionProvider;
import org.mevenide.grammar.AttributeCompletion;
import org.mevenide.grammar.TagLib;
import org.mevenide.grammar.TagLibProvider;
import org.mevenide.grammar.impl.EmptyAttributeCompletionImpl;
import org.mevenide.grammar.impl.GoalsAttributeCompletionImpl;
import org.mevenide.grammar.impl.MavenTagLibProvider;
import org.mevenide.grammar.impl.PluginDefaultsCompletionImpl;
import org.mevenide.grammar.impl.StaticTagLibImpl;
import org.mevenide.netbeans.grammar.MavenGrammarModule;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.Repository;

public class NbTagLibProvider
implements TagLibProvider,
AttrCompletionProvider {
    private static Log logger = LogFactory.getLog((Class)NbTagLibProvider.class);
    private File dynaTagFile = new File(ConfigUtils.getDefaultLocationFinder().getMavenPluginsDir(), "dynatag.cache");
    private MavenTagLibProvider mavenProvider = new MavenTagLibProvider(this.dynaTagFile){

        protected ClassLoader getMavenClassLoader() {
            return MavenGrammarModule.getMavenClassLoader();
        }
    };

    public String[] getAvailableTags() {
        FileObject tagLibFolder = Repository.getDefault().getDefaultFileSystem().findResource("Plugins/Mevenide-Grammar");
        FileObject[] libFOs = tagLibFolder.getChildren();
        HashSet<String> toReturn = new HashSet<String>();
        if (libFOs != null) {
            for (int i = 0; i < libFOs.length; ++i) {
                if (!libFOs[i].getExt().equals("xml") || libFOs[i].getName().startsWith("default")) continue;
                toReturn.add(libFOs[i].getName().replace('-', ':'));
            }
        }
        String[] mavenTags = this.mavenProvider.getAvailableTags();
        for (int i = 0; i < mavenTags.length; ++i) {
            toReturn.add(mavenTags[i]);
        }
        String[] str = new String[toReturn.size()];
        str = toReturn.toArray(str);
        return str;
    }

    public TagLib retrieveTagLib(String name) {
        TagLib toReturn = null;
        toReturn = this.mavenProvider.retrieveTagLib(name);
        if (toReturn != null) {
            return toReturn;
        }
        name = name.replace(':', '-');
        FileObject tagLib = Repository.getDefault().getDefaultFileSystem().findResource("Plugins/Mevenide-Grammar/" + name + ".xml");
        if (tagLib == null) {
            logger.error((Object)("cannot find taglib with name=" + name + "  (no fileobject found)"));
            return null;
        }
        try {
            toReturn = new StaticTagLibImpl(tagLib.getInputStream());
        }
        catch (Exception exc) {
            logger.error((Object)("cannot retrieve the taglibrary=" + name), (Throwable)exc);
        }
        return toReturn;
    }

    public AttributeCompletion retrieveAttributeCompletion(String name) {
        GoalsAttributeCompletionImpl completion = null;
        if ("goal".equals(name)) {
            try {
                completion = new GoalsAttributeCompletionImpl();
            }
            catch (Exception exc) {
                logger.error((Object)"Cannot create new instance of GoalsAttributeCompletionImpl", (Throwable)exc);
            }
        }
        if ("pluginDefaults".equals(name)) {
            completion = new PluginDefaultsCompletionImpl();
        }
        if (completion == null) {
            logger.warn((Object)("AttributeCompletion: using a fallback implementation, no impl for type=" + name));
            completion = new EmptyAttributeCompletionImpl(name);
        }
        return completion;
    }
}

