/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extras.pgp;

import cryptix.jce.provider.CryptixCrypto;
import cryptix.openpgp.provider.CryptixOpenPGP;
import cryptix.pki.ExtendedKeyStore;
import cryptix.pki.KeyBundle;
import java.io.InputStream;
import java.security.Principal;
import java.security.Provider;
import java.security.Security;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.config.i18n.Message;
import org.mule.extras.pgp.PGPKeyRing;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.util.Utility;

public class PGPKeyRingImpl
implements PGPKeyRing {
    protected static transient Log logger = LogFactory.getLog((Class)(class$org$mule$extras$pgp$PGPKeyRingImpl == null ? (class$org$mule$extras$pgp$PGPKeyRingImpl = PGPKeyRingImpl.class$("org.mule.extras.pgp.PGPKeyRingImpl")) : class$org$mule$extras$pgp$PGPKeyRingImpl));
    private String publicKeyRingFileName;
    private HashMap principalsKeyBundleMap;
    private String secretKeyRingFileName;
    private String secretAliasId;
    private KeyBundle secretKeyBundle;
    private String secretPassphrase;
    static /* synthetic */ Class class$org$mule$extras$pgp$PGPKeyRingImpl;

    public String getSecretKeyRingFileName() {
        return this.secretKeyRingFileName;
    }

    public void setSecretKeyRingFileName(String value) {
        this.secretKeyRingFileName = value;
    }

    public String getSecretAliasId() {
        return this.secretAliasId;
    }

    public void setSecretAliasId(String value) {
        this.secretAliasId = value;
    }

    public String getSecretPassphrase() {
        return this.secretPassphrase;
    }

    public void setSecretPassphrase(String value) {
        this.secretPassphrase = value;
    }

    private void readPrivateKeyBundle() throws Exception {
        InputStream in = Utility.loadResource((String)this.secretKeyRingFileName, this.getClass());
        ExtendedKeyStore ring = (ExtendedKeyStore)ExtendedKeyStore.getInstance((String)"OpenPGP/KeyRing");
        ring.load(in, null);
        in.close();
        this.secretKeyBundle = ring.getKeyBundle(this.secretAliasId);
    }

    public KeyBundle getSecretKeyBundle() {
        return this.secretKeyBundle;
    }

    public String getPublicKeyRingFileName() {
        return this.publicKeyRingFileName;
    }

    public void setPublicKeyRingFileName(String value) {
        this.publicKeyRingFileName = value;
    }

    public KeyBundle getKeyBundle(String principalId) {
        return (KeyBundle)this.principalsKeyBundleMap.get(principalId);
    }

    public void initialise() throws InitialisationException {
        try {
            Security.addProvider((Provider)new CryptixCrypto());
            Security.addProvider((Provider)new CryptixOpenPGP());
            this.principalsKeyBundleMap = new HashMap();
            this.readPublicKeyRing();
            this.readPrivateKeyBundle();
        }
        catch (Exception e) {
            logger.error((Object)("errore in inizializzazione:" + e.getMessage()), (Throwable)e);
            throw new InitialisationException(new Message(65, (Object)"PGPKeyRingImpl"), (Object)e);
        }
    }

    private void readPublicKeyRing() throws Exception {
        logger.debug(System.getProperties().get("user.dir"));
        InputStream in = Utility.loadResource((String)this.publicKeyRingFileName, this.getClass());
        ExtendedKeyStore ring = (ExtendedKeyStore)ExtendedKeyStore.getInstance((String)"OpenPGP/KeyRing");
        ring.load(in, null);
        in.close();
        Enumeration e = ring.aliases();
        while (e.hasMoreElements()) {
            String aliasId = (String)e.nextElement();
            KeyBundle bundle = ring.getKeyBundle(aliasId);
            if (bundle == null) continue;
            Iterator users = bundle.getPrincipals();
            while (users.hasNext()) {
                Principal princ = (Principal)users.next();
                this.principalsKeyBundleMap.put(princ.getName(), bundle);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

