/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extras.pgp;

import cryptix.jce.provider.CryptixCrypto;
import cryptix.message.Message;
import cryptix.message.MessageException;
import cryptix.message.SignedMessage;
import cryptix.openpgp.provider.CryptixOpenPGP;
import cryptix.pki.KeyBundle;
import java.security.Provider;
import java.security.Security;
import org.mule.extras.pgp.PGPAuthentication;
import org.mule.extras.pgp.PGPKeyRing;
import org.mule.extras.pgp.PGPSecurityContextFactory;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.security.SecurityException;
import org.mule.umo.security.UMOAuthentication;
import org.mule.umo.security.UMOSecurityContext;
import org.mule.umo.security.UMOSecurityContextFactory;
import org.mule.umo.security.UMOSecurityProvider;
import org.mule.umo.security.UnauthorisedException;
import org.mule.umo.security.UnknownAuthenticationTypeException;

public class PGPSecurityProvider
implements UMOSecurityProvider {
    private String name = "PGPSecurityProvider";
    private PGPKeyRing keyManager;
    private UMOSecurityContextFactory factory;
    static /* synthetic */ Class class$org$mule$extras$pgp$PGPAuthentication;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public UMOAuthentication authenticate(UMOAuthentication authentication) throws SecurityException {
        PGPAuthentication auth = (PGPAuthentication)authentication;
        String userId = (String)auth.getPrincipal();
        if (userId == null) {
            throw new UnauthorisedException(new org.mule.config.i18n.Message(45, (Object)"UserId"));
        }
        KeyBundle userKeyBundle = this.keyManager.getKeyBundle(userId);
        if (userKeyBundle == null) {
            throw new UnauthorisedException(new org.mule.config.i18n.Message("pgp", 1, (Object)userId));
        }
        Message msg = (Message)auth.getCredentials();
        if (msg == null || !(msg instanceof SignedMessage)) {
            throw new UnauthorisedException(new org.mule.config.i18n.Message("pgp", 2));
        }
        try {
            if (!((SignedMessage)msg).verify(userKeyBundle)) {
                throw new UnauthorisedException(new org.mule.config.i18n.Message("pgp", 3));
            }
        }
        catch (MessageException e) {
            throw new UnauthorisedException(new org.mule.config.i18n.Message("pgp", 4), (Throwable)e);
        }
        auth.setAuthenticated(true);
        auth.setDetails(userKeyBundle);
        return auth;
    }

    public boolean supports(Class aClass) {
        return (class$org$mule$extras$pgp$PGPAuthentication == null ? (class$org$mule$extras$pgp$PGPAuthentication = PGPSecurityProvider.class$("org.mule.extras.pgp.PGPAuthentication")) : class$org$mule$extras$pgp$PGPAuthentication).isAssignableFrom(aClass);
    }

    public UMOSecurityContext createSecurityContext(UMOAuthentication auth) throws UnknownAuthenticationTypeException {
        return this.factory.create(auth);
    }

    public void initialise() throws InitialisationException {
        try {
            Security.addProvider((Provider)new CryptixCrypto());
            Security.addProvider((Provider)new CryptixOpenPGP());
            this.factory = new PGPSecurityContextFactory();
        }
        catch (Exception e) {
            throw new InitialisationException(new org.mule.config.i18n.Message(65, (Object)"PGPProvider"), (Object)e);
        }
    }

    public PGPKeyRing getKeyManager() {
        return this.keyManager;
    }

    public void setKeyManager(PGPKeyRing keyManager) {
        this.keyManager = keyManager;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

