/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extras.picocontainer;

import java.io.Reader;
import java.io.StringReader;
import java.util.Map;
import org.mule.umo.model.ComponentNotFoundException;
import org.mule.umo.model.ComponentResolverException;
import org.mule.umo.model.UMOContainerContext;
import org.mule.util.ClassHelper;
import org.mule.util.Utility;
import org.nanocontainer.integrationkit.PicoCompositionException;
import org.nanocontainer.script.ScriptedContainerBuilder;
import org.nanocontainer.script.ScriptedContainerBuilderFactory;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.defaults.ObjectReference;
import org.picocontainer.defaults.SimpleReference;

public class PicoContainerContext
implements UMOContainerContext {
    public static final String CONFIGEXTENSION = "CONFIG";
    protected String configFile;
    private MutablePicoContainer container;

    public Object getComponent(Object key) throws ComponentNotFoundException {
        if (this.container == null) {
            throw new IllegalStateException("Pico container has not been set");
        }
        if (key == null) {
            throw new ComponentNotFoundException("Component not found for null key");
        }
        Object component = null;
        if (key instanceof String) {
            try {
                Class keyClass = ClassHelper.loadClass((String)((String)key), this.getClass());
                component = this.container.getComponentInstance((Object)keyClass);
            }
            catch (ClassNotFoundException e) {
                component = this.container.getComponentInstance(key);
            }
        } else {
            component = this.container.getComponentInstance(key);
        }
        if (component == null) {
            throw new ComponentNotFoundException("Component not found for key: " + key.toString());
        }
        return component;
    }

    public MutablePicoContainer getContainer() {
        return this.container;
    }

    public void setContainer(MutablePicoContainer container) {
        this.container = container;
    }

    public void setConfigFile(String configFile) throws PicoCompositionException {
        this.configFile = configFile;
        try {
            String builderClassName = this.getBuilderClassName(configFile);
            String configString = Utility.loadResourceAsString((String)configFile, this.getClass());
            StringReader configReader = new StringReader(configString);
            this.doConfigure(configReader, builderClassName);
        }
        catch (Exception e) {
            throw new PicoCompositionException((Throwable)e);
        }
    }

    public void configure(Reader configuration, Map configurationProperties) throws ComponentResolverException {
        String extension = (String)configurationProperties.get(CONFIGEXTENSION);
        if (extension == null) {
            extension = ".xml";
        }
        String className = ScriptedContainerBuilderFactory.getBuilderClassName((String)extension);
        this.doConfigure(configuration, className);
    }

    protected void doConfigure(Reader configReader, String builderClassName) throws ComponentResolverException {
        SimpleReference containerRef = new SimpleReference();
        SimpleReference parentContainerRef = new SimpleReference();
        ScriptedContainerBuilderFactory scriptedContainerBuilderFactory = null;
        try {
            scriptedContainerBuilderFactory = new ScriptedContainerBuilderFactory(configReader, builderClassName, Thread.currentThread().getContextClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new ComponentResolverException("could not configure pico", (Throwable)e);
        }
        ScriptedContainerBuilder builder = scriptedContainerBuilderFactory.getContainerBuilder();
        builder.buildContainer((ObjectReference)containerRef, (ObjectReference)parentContainerRef, null, false);
        this.setContainer((MutablePicoContainer)containerRef.get());
    }

    private String getBuilderClassName(String scriptName) {
        String extension = scriptName.substring(scriptName.lastIndexOf(46));
        return ScriptedContainerBuilderFactory.getBuilderClassName((String)extension);
    }
}

