/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extras.plexus;

import java.io.Reader;
import java.net.URL;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.embed.Embedder;
import org.mule.config.ConfigurationException;
import org.mule.config.i18n.Message;
import org.mule.impl.container.AbstractContainerContext;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.lifecycle.RecoverableException;
import org.mule.umo.manager.ContainerException;
import org.mule.umo.manager.ObjectNotFoundException;
import org.mule.util.Utility;

public class PlexusContainerContext
extends AbstractContainerContext {
    protected Embedder container;
    protected String configFile;

    public PlexusContainerContext() {
        this(new Embedder());
    }

    public PlexusContainerContext(Embedder container) {
        super("plexus");
        this.container = container;
    }

    public Object getComponent(Object key) throws ObjectNotFoundException {
        if (key == null) {
            throw new ObjectNotFoundException("Component not found for null key");
        }
        try {
            String compKey = key instanceof Class ? ((Class)key).getName() : key.toString();
            return this.container.lookup(compKey);
        }
        catch (ComponentLookupException e) {
            throw new ObjectNotFoundException("could not load component", (Throwable)e);
        }
    }

    public void configure(Reader configuration) throws ContainerException {
        try {
            this.container.setConfiguration(configuration);
            this.container.start();
        }
        catch (Exception e) {
            throw new ContainerException(new Message(123), (Throwable)e);
        }
    }

    public String getConfigFile() {
        return this.configFile;
    }

    public void setConfigFile(String configFile) throws ConfigurationException {
        this.configFile = configFile;
    }

    public void initialise() throws InitialisationException, RecoverableException {
        if (this.configFile == null) {
            return;
        }
        try {
            URL url = Utility.getResource((String)this.configFile, ((Object)((Object)this)).getClass());
            if (url == null) {
                throw new ConfigurationException(new Message(122, (Object)this.configFile));
            }
            this.container.setConfiguration(url);
            this.container.start();
        }
        catch (Exception e) {
            throw new InitialisationException(new Message(74, (Object)"Plexus container", (Object)this.configFile), (Object)this);
        }
    }

    public void dispose() {
        if (this.container != null) {
            try {
                this.container.stop();
            }
            catch (Exception e) {
                this.logger.info((Object)"Plexus container", (Throwable)e);
            }
        }
    }
}

