/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.file;

import java.io.File;
import java.io.FilenameFilter;
import java.util.Date;
import org.mule.MuleException;
import org.mule.config.i18n.Message;
import org.mule.impl.MuleMessage;
import org.mule.providers.ConnectException;
import org.mule.providers.PollingMessageReceiver;
import org.mule.providers.file.FileConnector;
import org.mule.umo.UMOComponent;
import org.mule.umo.UMOException;
import org.mule.umo.UMOMessage;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.provider.UMOConnector;
import org.mule.umo.provider.UMOMessageAdapter;
import org.mule.util.Utility;

public class FileMessageReceiver
extends PollingMessageReceiver {
    private String readDir = null;
    private String moveDir = null;
    private File readDirectory = null;
    private File moveDirectory = null;
    private String moveToPattern = null;
    private FilenameFilter filenameFilter = null;

    public FileMessageReceiver(UMOConnector connector, UMOComponent component, UMOEndpoint endpoint, String readDir, String moveDir, String moveToPattern, Long frequency) throws InitialisationException {
        super(connector, component, endpoint, frequency);
        this.readDir = readDir;
        this.moveDir = moveDir;
        this.moveToPattern = moveToPattern;
        if (endpoint.getFilter() instanceof FilenameFilter) {
            this.filenameFilter = (FilenameFilter)endpoint.getFilter();
        }
    }

    public void doConnect() throws Exception {
        if (this.readDir != null) {
            this.readDirectory = Utility.openDirectory((String)this.readDir);
            if (!this.readDirectory.canRead()) {
                throw new ConnectException(new Message(149, (Object)this.readDirectory.getAbsolutePath()), (Object)this);
            }
            this.logger.debug((Object)("Listening on endpointUri: " + this.readDirectory.getAbsolutePath()));
        }
        if (this.moveDir != null) {
            this.moveDirectory = Utility.openDirectory((String)this.moveDir);
            if (!this.moveDirectory.canRead() || !this.moveDirectory.canWrite()) {
                throw new ConnectException(new Message("file", 5), (Object)this);
            }
        }
    }

    public void doDisconnect() throws Exception {
    }

    public void poll() {
        try {
            File[] files = this.listFiles();
            if (files == null) {
                return;
            }
            for (int i = 0; i < files.length; ++i) {
                this.processFile(files[i]);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public synchronized void processFile(File file) throws UMOException {
        boolean checkFileAge = ((FileConnector)this.connector).getCheckFileAge();
        if (checkFileAge) {
            long fileAge = ((FileConnector)this.connector).getFileAge();
            long lastMod = file.lastModified();
            long now = new Date().getTime();
            if (now - lastMod < fileAge) {
                return;
            }
        }
        File destinationFile = null;
        String orginalFilename = file.getName();
        UMOMessageAdapter msgAdapter = this.connector.getMessageAdapter((Object)file);
        msgAdapter.setProperty((Object)"originalFilename", (Object)orginalFilename);
        if (this.moveDir != null) {
            String fileName = file.getName();
            if (this.moveToPattern != null) {
                fileName = ((FileConnector)this.connector).getFilenameParser().getFilename(msgAdapter, this.moveToPattern);
            }
            destinationFile = new File(this.moveDir, fileName);
        }
        boolean resultOfFileMoveOperation = false;
        try {
            if (!(file.canRead() && file.exists() && file.isFile())) {
                throw new MuleException(new Message(149, (Object)file.getName()));
            }
            if (destinationFile != null) {
                resultOfFileMoveOperation = file.renameTo(destinationFile);
                if (!resultOfFileMoveOperation) {
                    throw new MuleException(new Message("file", 4, (Object)file.getAbsolutePath(), (Object)destinationFile.getAbsolutePath()));
                }
                msgAdapter = this.connector.getMessageAdapter((Object)destinationFile);
            }
            if (((FileConnector)this.connector).isAutoDelete()) {
                msgAdapter.getPayloadAsBytes();
                if (destinationFile == null && !(resultOfFileMoveOperation = file.delete())) {
                    throw new MuleException(new Message("file", 3, (Object)file.getAbsolutePath()));
                }
            }
            MuleMessage message = new MuleMessage((Object)msgAdapter);
            this.routeMessage((UMOMessage)message, this.endpoint.isSynchronous());
        }
        catch (Exception e) {
            boolean resultOfRollbackFileMove = false;
            if (resultOfFileMoveOperation) {
                resultOfRollbackFileMove = this.rollbackFileMove(destinationFile, file.getAbsolutePath());
            }
            MuleException ex = new MuleException(new Message("file", 2, (Object)file.getName(), (Object)(resultOfRollbackFileMove ? "successful" : "unsuccessful")), (Throwable)e);
            this.handleException((Exception)ex);
        }
    }

    private boolean rollbackFileMove(File sourceFile, String destinationFilePath) {
        boolean result = false;
        try {
            result = sourceFile.renameTo(new File(destinationFilePath));
        }
        catch (Throwable t) {
            this.logger.debug((Object)("rollback of file move failed: " + t.getMessage()));
        }
        return result;
    }

    File[] listFiles() throws MuleException {
        File[] todoFiles = new File[]{};
        try {
            todoFiles = this.readDirectory.listFiles(this.filenameFilter);
        }
        catch (Exception e) {
            throw new MuleException(new Message("file", 1), (Throwable)e);
        }
        return todoFiles;
    }
}

