/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.model.bpel._2_0;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.bpelunit.model.bpel.IActivity;
import net.bpelunit.model.bpel.IBpelObject;
import net.bpelunit.model.bpel.IVisitor;
import net.bpelunit.model.bpel._2_0.AbstractActivity;
import net.bpelunit.model.bpel._2_0.BpelFactory;
import net.bpelunit.model.bpel._2_0.Documentation;
import org.oasis_open.docs.wsbpel._2_0.process.executable.TDocumentation;
import org.oasis_open.docs.wsbpel._2_0.process.executable.TExtensibleElements;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractBpelObject
implements IBpelObject {
    protected List<Documentation> documentations = new ArrayList<Documentation>();
    private TExtensibleElements nativeElement;
    private BpelFactory factory;

    public AbstractBpelObject(TExtensibleElements t, BpelFactory factory) {
        if (t == null) {
            throw new NullPointerException("Wrapped activity must not be null!");
        }
        this.factory = factory;
        this.nativeElement = t;
        for (TDocumentation d : this.nativeElement.getDocumentation()) {
            this.documentations.add(new Documentation(d, factory));
        }
    }

    @Override
    public BpelFactory getFactory() {
        return this.factory;
    }

    void checkForCorrectModel(IBpelObject o) {
        if (!(o instanceof AbstractBpelObject)) {
            throw new IllegalArgumentException(o.getClass() + " is not supported by the BPEL 2.0 facade.");
        }
    }

    AbstractActivity<?> checkForCorrectModel(IActivity a) {
        try {
            return (AbstractActivity)a;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(a.getClass() + " is not supported by the BPEL 2.0 facade.");
        }
    }

    public List<Documentation> getDocumentation() {
        return Collections.unmodifiableList(this.documentations);
    }

    @Override
    public Documentation addDocumentation() {
        TDocumentation bpelDoc = new TDocumentation();
        Documentation bpelDocumentation = this.getFactory().createDocumentation(bpelDoc);
        this.nativeElement.getDocumentation().add(bpelDoc);
        this.documentations.add(bpelDocumentation);
        return bpelDocumentation;
    }

    @Override
    public String getXPathInDocument() {
        return null;
    }

    abstract IBpelObject getObjectForNativeObject(Object var1);

    abstract void visit(IVisitor var1);
}

