/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.model.bpel._2_0;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.bpelunit.model.bpel.IFlow;
import net.bpelunit.model.bpel.ILink;
import net.bpelunit.model.bpel.IVisitor;
import net.bpelunit.model.bpel._2_0.AbstractActivity;
import net.bpelunit.model.bpel._2_0.AbstractMultiContainer;
import net.bpelunit.model.bpel._2_0.BpelFactory;
import net.bpelunit.model.bpel._2_0.Link;
import org.oasis_open.docs.wsbpel._2_0.process.executable.TFlow;
import org.oasis_open.docs.wsbpel._2_0.process.executable.TLink;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Flow
extends AbstractMultiContainer<TFlow>
implements IFlow {
    private TFlow flow;
    private List<Link> links = new ArrayList<Link>();

    Flow(TFlow wrappedFlow, BpelFactory f) {
        super(wrappedFlow, wrappedFlow.getActivity(), f);
        this.flow = wrappedFlow;
        for (TLink l : wrappedFlow.getLinks().getLink()) {
            this.links.add(this.getFactory().createLink(l));
        }
    }

    public List<Link> getLinks() {
        return Collections.unmodifiableList(this.links);
    }

    @Override
    public Link addLink(String name) {
        TLink l = new TLink();
        l.setName(name);
        Link link = this.getFactory().createLink(l);
        this.flow.getLinks().getLink().add(l);
        this.links.add(link);
        return link;
    }

    @Override
    public void removeLink(ILink l) {
        this.checkForCorrectModel(l);
        int i = this.links.indexOf(l);
        this.links.remove(i);
        this.flow.getLinks().getLink().remove(i);
    }

    @Override
    public void visit(IVisitor v) {
        v.visit(this);
        for (AbstractActivity<?> a : this.getActivities()) {
            a.visit(v);
        }
    }
}

