/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.model.bpel._2_0;

import java.util.Collections;
import java.util.List;
import net.bpelunit.model.bpel.IFrom;
import net.bpelunit.model.bpel.IVariable;
import net.bpelunit.model.bpel._2_0.BpelFactory;
import org.oasis_open.docs.wsbpel._2_0.process.executable.ObjectFactory;
import org.oasis_open.docs.wsbpel._2_0.process.executable.TFrom;
import org.oasis_open.docs.wsbpel._2_0.process.executable.TLiteral;
import org.oasis_open.docs.wsbpel._2_0.process.executable.TQuery;
import org.oasis_open.docs.wsbpel._2_0.process.executable.TRoles;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class From
implements IFrom {
    private BpelFactory factory;
    private TFrom from;

    From(TFrom wrappedFrom, BpelFactory f) {
        this.from = wrappedFrom;
        this.factory = f;
    }

    @Override
    public List<Object> getContent() {
        return Collections.unmodifiableList(this.from.getContent());
    }

    @Override
    public IFrom.Roles getEndpointReference() {
        if (this.from.getEndpointReference() == TRoles.MY_ROLE) {
            return IFrom.Roles.MY_ROLE;
        }
        if (this.from.getEndpointReference() == TRoles.PARTNER_ROLE) {
            return IFrom.Roles.PARTNER_ROLE;
        }
        return null;
    }

    @Override
    public String getExpressionLanguage() {
        return this.from.getExpressionLanguage();
    }

    TFrom getNativeFrom() {
        return this.from;
    }

    @Override
    public String getPart() {
        return this.from.getPart();
    }

    @Override
    public String getPartnerLink() {
        return this.from.getPartnerLink();
    }

    @Override
    public String getVariable() {
        return this.from.getVariable();
    }

    @Override
    public void setContent(List<Object> content) {
        this.from.getContent().clear();
        if (content != null) {
            this.from.getContent().addAll(content);
        }
    }

    @Override
    public void setEndpointReference(IFrom.Roles value) {
        if (value == IFrom.Roles.MY_ROLE) {
            this.from.setEndpointReference(TRoles.MY_ROLE);
        } else if (value == IFrom.Roles.PARTNER_ROLE) {
            this.from.setEndpointReference(TRoles.PARTNER_ROLE);
        } else {
            this.from.setEndpointReference(null);
        }
    }

    @Override
    public void setExpression(String expr) {
        TQuery tq = new TQuery();
        tq.getContent().add(expr);
        this.from.getContent().clear();
        this.from.getContent().add(new ObjectFactory().createQuery(tq));
    }

    @Override
    public void setExpressionLanguage(String value) {
        this.from.setExpressionLanguage(value);
    }

    @Override
    public void setLiteral(Object c) {
        List<Object> content = this.from.getContent();
        content.clear();
        TLiteral literal = new TLiteral();
        literal.getContent().add(c);
        content.add(new ObjectFactory().createLiteral(literal));
        this.factory.registerClass(c.getClass());
    }

    @Override
    public void setPart(String value) {
        this.from.setPart(value);
    }

    @Override
    public void setPartnerLink(String value) {
        this.from.setPartnerLink(value);
    }

    @Override
    public void setVariable(IVariable v) {
        this.setVariable(v.getName());
    }

    @Override
    public void setVariable(String value) {
        this.from.setVariable(value);
    }
}

