/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.model.bpel._2_0;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.bpelunit.model.bpel.IBpelObject;
import net.bpelunit.model.bpel.IOnAlarm;
import net.bpelunit.model.bpel.IOnMessage;
import net.bpelunit.model.bpel.IPick;
import net.bpelunit.model.bpel.IVisitor;
import net.bpelunit.model.bpel._2_0.AbstractActivity;
import net.bpelunit.model.bpel._2_0.BpelFactory;
import net.bpelunit.model.bpel._2_0.OnAlarm;
import net.bpelunit.model.bpel._2_0.OnMessage;
import org.oasis_open.docs.wsbpel._2_0.process.executable.TBoolean;
import org.oasis_open.docs.wsbpel._2_0.process.executable.TOnAlarmPick;
import org.oasis_open.docs.wsbpel._2_0.process.executable.TOnMessage;
import org.oasis_open.docs.wsbpel._2_0.process.executable.TPick;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Pick
extends AbstractActivity<TPick>
implements IPick {
    private List<OnMessage> onMessages = new ArrayList<OnMessage>();
    private List<OnAlarm> onAlarms = new ArrayList<OnAlarm>();
    private BpelFactory factory;

    public Pick(TPick wrappedPick, BpelFactory f) {
        super(wrappedPick, f);
        this.factory = f;
        for (TOnMessage m : wrappedPick.getOnMessage()) {
            this.onMessages.add(new OnMessage(m, f));
        }
        for (TOnAlarmPick a : wrappedPick.getOnAlarm()) {
            this.onAlarms.add(new OnAlarm(a, f));
        }
    }

    @Override
    public boolean isBasicActivity() {
        return false;
    }

    @Override
    public void visit(IVisitor v) {
        v.visit(this);
        for (OnMessage m : this.onMessages) {
            v.visit(m);
        }
        for (OnAlarm a : this.onAlarms) {
            v.visit(a);
        }
    }

    @Override
    public void setCreateInstance(boolean b) {
        if (b) {
            ((TPick)this.getNativeActivity()).setCreateInstance(TBoolean.YES);
        } else {
            ((TPick)this.getNativeActivity()).setCreateInstance(TBoolean.NO);
        }
    }

    @Override
    public boolean isCreateInstance() {
        return TBoolean.YES.equals((Object)((TPick)this.getNativeActivity()).getCreateInstance());
    }

    @Override
    public List<? extends IOnMessage> getOnMessages() {
        return Collections.unmodifiableList(this.onMessages);
    }

    @Override
    public List<? extends IOnAlarm> getOnAlarms() {
        return Collections.unmodifiableList(this.onAlarms);
    }

    @Override
    public OnMessage addOnMessage() {
        TOnMessage nativeOnMessage = new TOnMessage();
        OnMessage onMessage = new OnMessage(nativeOnMessage, this.factory);
        this.onMessages.add(onMessage);
        ((TPick)this.getNativeActivity()).getOnMessage().add(nativeOnMessage);
        return onMessage;
    }

    @Override
    public OnAlarm addOnAlarm() {
        TOnAlarmPick nativeOnAlarm = new TOnAlarmPick();
        OnAlarm onAlarm = new OnAlarm(nativeOnAlarm, this.factory);
        this.onAlarms.add(onAlarm);
        ((TPick)this.getNativeActivity()).getOnAlarm().add(nativeOnAlarm);
        return onAlarm;
    }

    @Override
    IBpelObject getObjectForNativeObject(Object nativeObject) {
        IBpelObject o;
        if (nativeObject == this.getNativeActivity()) {
            return this;
        }
        for (OnMessage m : this.onMessages) {
            o = m.getObjectForNativeObject(nativeObject);
            if (o == null) continue;
            return o;
        }
        for (OnAlarm a : this.onAlarms) {
            o = a.getObjectForNativeObject(nativeObject);
            if (o == null) continue;
            return o;
        }
        return null;
    }
}

