/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.model.bpel._2_0;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import net.bpelunit.model.bpel.IActivity;
import net.bpelunit.model.bpel.IBpelObject;
import net.bpelunit.model.bpel.IImport;
import net.bpelunit.model.bpel.IPartnerLink;
import net.bpelunit.model.bpel.IProcess;
import net.bpelunit.model.bpel.IVariable;
import net.bpelunit.model.bpel.IVisitor;
import net.bpelunit.model.bpel._2_0.AbstractActivity;
import net.bpelunit.model.bpel._2_0.AbstractBpelObject;
import net.bpelunit.model.bpel._2_0.BpelFactory;
import net.bpelunit.model.bpel._2_0.Import;
import net.bpelunit.model.bpel._2_0.PartnerLink;
import net.bpelunit.model.bpel._2_0.TComplexContainerHelper;
import net.bpelunit.model.bpel._2_0.Variable;
import org.apache.commons.io.IOUtils;
import org.apache.commons.jxpath.JXPathContext;
import org.oasis_open.docs.wsbpel._2_0.process.executable.ObjectFactory;
import org.oasis_open.docs.wsbpel._2_0.process.executable.TActivity;
import org.oasis_open.docs.wsbpel._2_0.process.executable.TBoolean;
import org.oasis_open.docs.wsbpel._2_0.process.executable.TImport;
import org.oasis_open.docs.wsbpel._2_0.process.executable.TPartnerLink;
import org.oasis_open.docs.wsbpel._2_0.process.executable.TPartnerLinks;
import org.oasis_open.docs.wsbpel._2_0.process.executable.TProcess;
import org.oasis_open.docs.wsbpel._2_0.process.executable.TVariable;
import org.oasis_open.docs.wsbpel._2_0.process.executable.TVariables;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Process
extends AbstractBpelObject
implements IProcess {
    private TProcess process;
    private AbstractActivity<?> mainActivity;
    private List<PartnerLink> partnerLinks = new ArrayList<PartnerLink>();
    private List<Import> imports = new ArrayList<Import>();
    private List<Variable> variables = new ArrayList<Variable>();
    private BpelFactory factory;

    Process(TProcess newProcess, BpelFactory f) {
        super(newProcess, null);
        this.factory = f;
        TActivity childActivity = TComplexContainerHelper.getChildActivity(newProcess);
        this.process = newProcess;
        this.setMainActivity(f.createActivity(childActivity));
        if (newProcess.getPartnerLinks() != null) {
            for (TPartnerLink p : newProcess.getPartnerLinks().getPartnerLink()) {
                this.partnerLinks.add(this.getFactory().createPartnerLink(p));
            }
        }
        for (TImport i : newProcess.getImport()) {
            this.imports.add(this.getFactory().createImport(i));
        }
        if (newProcess.getVariables() == null) {
            newProcess.setVariables(new TVariables());
        }
        for (TVariable v : newProcess.getVariables().getVariable()) {
            this.variables.add(this.getFactory().createVariable(v));
        }
    }

    @Override
    public BpelFactory getFactory() {
        return this.factory;
    }

    @Override
    public String getName() {
        return this.process.getName();
    }

    @Override
    public String getTargetNamespace() {
        return this.process.getTargetNamespace();
    }

    @Override
    public String getQueryLanguage() {
        return this.process.getQueryLanguage();
    }

    @Override
    public boolean getSuppressJoinFailure() {
        return this.process.getSuppressJoinFailure().equals((Object)TBoolean.YES);
    }

    @Override
    public void setName(String value) {
        this.process.setName(value);
    }

    @Override
    public void setTargetNamespace(String value) {
        this.process.setTargetNamespace(value);
    }

    @Override
    public void setMainActivity(IActivity a) {
        this.checkForCorrectModel(a);
        AbstractActivity activity = (AbstractActivity)a;
        TComplexContainerHelper.removeMainActivity(this.process);
        if (activity != null) {
            TComplexContainerHelper.setActivity(this.process, activity.getNativeActivity());
        } else {
            TComplexContainerHelper.setActivity(this.process, null);
        }
        this.mainActivity = activity;
    }

    @Override
    public AbstractActivity<?> getMainActivity() {
        return this.mainActivity;
    }

    @Override
    public List<? extends IPartnerLink> getPartnerLinks() {
        return Collections.unmodifiableList(this.partnerLinks);
    }

    public List<Import> getImports() {
        return Collections.unmodifiableList(this.imports);
    }

    @Override
    public void visit(IVisitor v) {
        v.visit(this);
        ((AbstractBpelObject)((Object)this.getMainActivity())).visit(v);
    }

    @Override
    public List<? extends IVariable> getVariables() {
        return Collections.unmodifiableList(this.variables);
    }

    @Override
    public IVariable addVariable() {
        TVariable nativeVariable = new TVariable();
        Variable variable = this.getFactory().createVariable(nativeVariable);
        this.process.getVariables().getVariable().add(nativeVariable);
        this.variables.add(variable);
        return variable;
    }

    @Override
    public IPartnerLink addPartnerLink() {
        TPartnerLink nativePartnerLink = new TPartnerLink();
        PartnerLink partnerLink = this.getFactory().createPartnerLink(nativePartnerLink);
        this.guaranteePartnerLinks(this.process);
        this.process.getPartnerLinks().getPartnerLink().add(nativePartnerLink);
        this.partnerLinks.add(partnerLink);
        return partnerLink;
    }

    private void guaranteePartnerLinks(TProcess p) {
        if (p.getPartnerLinks() == null) {
            p.setPartnerLinks(new TPartnerLinks());
        }
    }

    @Override
    public void save(OutputStream out, Class<?> ... additionalClasses) throws IOException {
        try {
            JAXBContext ctx = this.getFactory().getJAXBContext();
            JAXBElement<TProcess> rootElement = new ObjectFactory().createProcess(this.process);
            Marshaller marshaller = ctx.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            marshaller.marshal(rootElement, out);
        }
        catch (JAXBException e) {
            throw new IOException("Could not marshall BPEL process: " + e.getMessage(), e);
        }
        finally {
            IOUtils.closeQuietly((OutputStream)out);
        }
    }

    @Override
    public IImport addImport() {
        TImport nativeImport = new TImport();
        Import imp = this.getFactory().createImport(nativeImport);
        this.process.getImport().add(nativeImport);
        this.imports.add(imp);
        return imp;
    }

    @Override
    public List<IBpelObject> getElementsByXPath(String xpathToBpelElement) {
        JXPathContext context = JXPathContext.newContext((Object)this.process);
        ArrayList<IBpelObject> retval = new ArrayList<IBpelObject>();
        Iterator iter = context.iterate(xpathToBpelElement);
        while (iter.hasNext()) {
            Object o = iter.next();
            IBpelObject bo = this.getObjectForNativeObject(o);
            if (bo != null) {
                retval.add(bo);
                continue;
            }
            throw new RuntimeException("No object mapping for " + o + " evaluated from " + xpathToBpelElement);
        }
        return retval;
    }

    @Override
    IBpelObject getObjectForNativeObject(Object nativeObject) {
        if (this.mainActivity != null) {
            return this.mainActivity.getObjectForNativeObject(nativeObject);
        }
        return null;
    }
}

