/*
 * Decompiled with CFR 0.152.
 */
package donky.microsoft.aspnet.signalr.client;

import donky.microsoft.aspnet.signalr.client.ConnectionBase;
import donky.microsoft.aspnet.signalr.client.ConnectionState;
import donky.microsoft.aspnet.signalr.client.KeepAliveData;
import java.util.Calendar;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class HeartbeatMonitor {
    private Runnable mOnWarning;
    private Runnable mOnTimeout;
    private KeepAliveData mKeepAliveData;
    private ScheduledThreadPoolExecutor mExecutor;
    private boolean mTimedOut = false;
    private boolean mHasBeenWarned = false;
    private boolean mStopped = true;
    private Object mSync = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(KeepAliveData keepAliveData, final ConnectionBase connection) {
        if (keepAliveData == null) {
            throw new IllegalArgumentException("keepAliveData cannot be null");
        }
        if (this.mKeepAliveData != null) {
            this.stop();
        }
        Object object = this.mSync;
        synchronized (object) {
            this.mKeepAliveData = keepAliveData;
            this.mTimedOut = false;
            this.mHasBeenWarned = false;
            this.mStopped = false;
            long interval = this.mKeepAliveData.getCheckInterval();
            this.mExecutor = new ScheduledThreadPoolExecutor(1);
            this.mExecutor.scheduleAtFixedRate(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Object object = HeartbeatMonitor.this.mSync;
                    synchronized (object) {
                        if (!HeartbeatMonitor.this.mStopped && connection.getState() == ConnectionState.Connected) {
                            long lastKeepAlive = HeartbeatMonitor.this.mKeepAliveData.getLastKeepAlive();
                            long timeElapsed = Calendar.getInstance().getTimeInMillis() - lastKeepAlive;
                            if (timeElapsed >= HeartbeatMonitor.this.mKeepAliveData.getTimeout()) {
                                if (!HeartbeatMonitor.this.mTimedOut) {
                                    HeartbeatMonitor.this.mTimedOut = true;
                                    HeartbeatMonitor.this.mOnTimeout.run();
                                }
                            } else if (timeElapsed >= HeartbeatMonitor.this.mKeepAliveData.getTimeoutWarning()) {
                                if (!HeartbeatMonitor.this.mHasBeenWarned) {
                                    HeartbeatMonitor.this.mHasBeenWarned = true;
                                    HeartbeatMonitor.this.mOnWarning.run();
                                }
                            } else {
                                HeartbeatMonitor.this.mHasBeenWarned = false;
                                HeartbeatMonitor.this.mTimedOut = false;
                            }
                        }
                    }
                }
            }, interval, interval, TimeUnit.MILLISECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        if (!this.mStopped) {
            Object object = this.mSync;
            synchronized (object) {
                this.mStopped = true;
                if (this.mExecutor != null) {
                    this.mExecutor.shutdown();
                    this.mExecutor = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beat() {
        Object object = this.mSync;
        synchronized (object) {
            if (this.mKeepAliveData != null) {
                this.mKeepAliveData.setLastKeepAlive(Calendar.getInstance().getTimeInMillis());
            }
        }
    }

    public Runnable getOnWarning() {
        return this.mOnWarning;
    }

    public void setOnWarning(Runnable onWarning) {
        this.mOnWarning = onWarning;
    }

    public Runnable getOnTimeout() {
        return this.mOnTimeout;
    }

    public void setOnTimeout(Runnable onTimeout) {
        this.mOnTimeout = onTimeout;
    }

    public KeepAliveData getKeepAliveData() {
        return this.mKeepAliveData;
    }

    public void setKeepAliveData(KeepAliveData keepAliveData) {
        this.mKeepAliveData = keepAliveData;
    }
}

