/*
 * Decompiled with CFR 0.152.
 */
package donky.microsoft.aspnet.signalr.client;

import donky.microsoft.aspnet.signalr.client.Action;
import donky.microsoft.aspnet.signalr.client.ErrorCallback;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class SignalRFuture<V>
implements Future<V> {
    boolean mIsCancelled = false;
    boolean mIsDone = false;
    private V mResult = null;
    private List<Runnable> mOnCancelled = new ArrayList<Runnable>();
    private List<Action<V>> mOnDone = new ArrayList<Action<V>>();
    private Object mDoneLock = new Object();
    private List<ErrorCallback> mErrorCallback = new ArrayList<ErrorCallback>();
    private Queue<Throwable> mErrorQueue = new ConcurrentLinkedQueue<Throwable>();
    private Object mErrorLock = new Object();
    private Throwable mLastError = null;
    private Semaphore mResultSemaphore = new Semaphore(0);

    public void onCancelled(Runnable onCancelled) {
        this.mOnCancelled.add(onCancelled);
    }

    public void cancel() {
        this.mIsCancelled = true;
        if (this.mOnCancelled != null) {
            for (Runnable onCancelled : this.mOnCancelled) {
                onCancelled.run();
            }
        }
        this.mResultSemaphore.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setResult(V result) {
        Object object = this.mDoneLock;
        synchronized (object) {
            this.mResult = result;
            this.mIsDone = true;
            if (this.mOnDone.size() > 0) {
                for (Action<V> handler : this.mOnDone) {
                    try {
                        handler.run(result);
                    }
                    catch (Exception e) {
                        this.triggerError(e);
                    }
                }
            }
        }
        this.mResultSemaphore.release();
    }

    @Override
    public boolean isCancelled() {
        return this.mIsCancelled;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        this.cancel();
        return true;
    }

    @Override
    public V get() throws InterruptedException, ExecutionException {
        try {
            return this.get(Integer.MAX_VALUE, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            throw new ExecutionException(e);
        }
    }

    @Override
    public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        if (this.mResultSemaphore.tryAcquire(timeout, unit)) {
            if (this.errorWasTriggered()) {
                throw new ExecutionException(this.mLastError);
            }
            if (this.isCancelled()) {
                throw new InterruptedException("Operation was cancelled");
            }
            return this.mResult;
        }
        throw new TimeoutException();
    }

    @Override
    public boolean isDone() {
        return this.mIsDone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SignalRFuture<V> done(Action<V> action) {
        Object object = this.mDoneLock;
        synchronized (object) {
            this.mOnDone.add(action);
            if (this.isDone()) {
                try {
                    action.run(this.get());
                }
                catch (Exception e) {
                    this.triggerError(e);
                }
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SignalRFuture<V> onError(ErrorCallback errorCallback) {
        Object object = this.mErrorLock;
        synchronized (object) {
            this.mErrorCallback.add(errorCallback);
            while (!this.mErrorQueue.isEmpty()) {
                if (errorCallback == null) continue;
                errorCallback.onError(this.mErrorQueue.poll());
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void triggerError(Throwable error) {
        Object object = this.mErrorLock;
        synchronized (object) {
            this.mLastError = error;
            this.mResultSemaphore.release();
            if (this.mErrorCallback.size() > 0) {
                for (ErrorCallback handler : this.mErrorCallback) {
                    handler.onError(error);
                }
            } else {
                this.mErrorQueue.add(error);
            }
        }
    }

    public boolean errorWasTriggered() {
        return this.mLastError != null;
    }
}

