/*
 * Decompiled with CFR 0.152.
 */
package donky.microsoft.aspnet.signalr.client;

public class Version {
    int[] mParts;

    public Version(String version) {
        try {
            String[] parts = version.split("\\.");
            this.mParts = new int[parts.length];
            for (int i = 0; i < parts.length; ++i) {
                this.mParts[i] = Integer.parseInt(parts[i]);
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException(version);
        }
    }

    public int getPart(int index) {
        return this.mParts[index];
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof Version)) {
            return false;
        }
        Version v2 = (Version)o;
        if (v2.mParts.length != this.mParts.length) {
            return false;
        }
        for (int i = 0; i < this.mParts.length; ++i) {
            if (this.mParts[i] == v2.mParts[i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.mParts.length; ++i) {
            if (i != 0) {
                sb.append(".");
            }
            int part = this.mParts[i];
            sb.append(part);
        }
        return sb.toString().hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.mParts.length; ++i) {
            if (i != 0) {
                sb.append(".");
            }
            sb.append(this.mParts[i]);
        }
        return sb.toString();
    }
}

