/*
 * Decompiled with CFR 0.152.
 */
package donky.microsoft.aspnet.signalr.client.http;

import donky.microsoft.aspnet.signalr.client.Credentials;
import donky.microsoft.aspnet.signalr.client.http.Request;

public class BasicAuthenticationCredentials
implements Credentials {
    private String mUsername;
    private String mPassword;
    private Base64Encoder mEncoder;

    public BasicAuthenticationCredentials(String username, String password, Base64Encoder encoder) {
        this.initialize(username, password, encoder);
    }

    private void initialize(String username, String password, Base64Encoder encoder) {
        this.mUsername = username;
        this.mPassword = password;
        this.mEncoder = encoder;
        if (encoder == null) {
            throw new IllegalArgumentException("encoder");
        }
    }

    public String getUsername() {
        return this.mUsername;
    }

    public void setUsername(String username) {
        this.mUsername = username;
    }

    public String getPassword() {
        return this.mPassword;
    }

    public void setPassword(String password) {
        this.mPassword = password;
    }

    @Override
    public void prepareRequest(Request request) {
        String headerValue = this.mUsername + ":" + this.mPassword;
        headerValue = this.mEncoder.encodeBytes(headerValue.getBytes()).trim();
        request.addHeader("Authorization", "Basic " + headerValue);
    }

    public class InvalidPlatformException
    extends Exception {
        private static final long serialVersionUID = 1975952258601813204L;
    }

    public static interface Base64Encoder {
        public String encodeBytes(byte[] var1);
    }
}

